/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import net.sourceforge.squirrel_sql.fw.gui.CascadeInternalFramePositioner;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IInternalFramePositioner;
import net.sourceforge.squirrel_sql.fw.gui.action.SelectInternalFrameAction;

public class BaseMDIParentFrame
extends JFrame {
    private JDesktopPane _desktop;
    private IInternalFramePositioner _internalFramePositioner;
    private Map _children = new HashMap();
    private MyInternalFrameListener _childListener = new MyInternalFrameListener();

    protected BaseMDIParentFrame(JDesktopPane desktop) {
        this(null, desktop);
    }

    protected BaseMDIParentFrame(String title, JDesktopPane desktop) {
        super(title);
        if (desktop == null) {
            throw new IllegalArgumentException("null JDesktopPane passed");
        }
        this._desktop = desktop;
    }

    public void addInternalFrame(JInternalFrame child, boolean createMenuItem) {
        this.addInternalFrame(child, createMenuItem, null);
    }

    public void addInternalFrame(JInternalFrame child, boolean createMenuItem, Action action) {
        JMenu menu;
        if (child == null) {
            throw new IllegalArgumentException("Null JInternalFrame added");
        }
        child.setTitle(this.createTitleForChild(child));
        this._desktop.add(child);
        if (!GUIUtils.isToolWindow(child)) {
            this.positionNewInternalFrame(child);
        }
        JMenuItem menuItem = null;
        if (createMenuItem && (menu = this.getWindowsMenu()) != null) {
            if (action == null) {
                action = new SelectInternalFrameAction(child);
            }
            menuItem = menu.add(action);
        }
        this._children.put(child.getTitle(), new ChildInfo(child, menuItem));
        child.addInternalFrameListener(this._childListener);
    }

    public void internalFrameClosed(JInternalFrame child) {
        JMenu menu;
        child.removeInternalFrameListener(this._childListener);
        ChildInfo ci = (ChildInfo)this._children.remove(child.getTitle());
        if (ci != null && ci._menuItem != null && (menu = this.getWindowsMenu()) != null) {
            menu.remove(ci._menuItem);
        }
    }

    public JDesktopPane getDesktopPane() {
        return this._desktop;
    }

    public JMenu getWindowsMenu() {
        return null;
    }

    protected void positionNewInternalFrame(JInternalFrame child) {
        this.getInternalFramePositioner().positionInternalFrame(child);
    }

    protected IInternalFramePositioner getInternalFramePositioner() {
        if (this._internalFramePositioner == null) {
            this._internalFramePositioner = new CascadeInternalFramePositioner();
        }
        return this._internalFramePositioner;
    }

    private String createTitleForChild(JInternalFrame child) {
        String title;
        String origTitle = title = child.getTitle();
        int index = 0;
        while (this._children.get(title) != null) {
            title = origTitle + "(" + ++index + ")";
        }
        return title;
    }

    private static class ChildInfo {
        private JInternalFrame _child;
        private JMenuItem _menuItem;

        ChildInfo(JInternalFrame child, JMenuItem menuItem) {
            this._child = child;
            this._menuItem = menuItem;
        }
    }

    private class MyInternalFrameListener
    extends InternalFrameAdapter {
        private MyInternalFrameListener() {
        }

        public void internalFrameClosed(InternalFrameEvent evt) {
            BaseMDIParentFrame.this.internalFrameClosed((JInternalFrame)evt.getSource());
        }
    }
}

