/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.UIManager;

public class LookAndFeelComboBox
extends JComboBox {
    private Map _lafsByName = new TreeMap();
    private Map _lafsByClassName = new TreeMap();

    public LookAndFeelComboBox() {
        this((String)null);
    }

    public LookAndFeelComboBox(String selectedLafName) {
        this.generateLookAndFeelInfo();
        if (selectedLafName == null) {
            selectedLafName = UIManager.getLookAndFeel().getName();
        }
        this.setSelectedLookAndFeelName(selectedLafName);
    }

    public UIManager.LookAndFeelInfo getSelectedLookAndFeel() {
        return (UIManager.LookAndFeelInfo)this._lafsByName.get(this.getSelectedItem());
    }

    public void setSelectedLookAndFeelName(String selectedLafName) {
        if (selectedLafName != null) {
            this.getModel().setSelectedItem(selectedLafName);
        }
    }

    public void setSelectedLookAndFeelClassName(String selectedLafClassName) {
        UIManager.LookAndFeelInfo info;
        if (selectedLafClassName != null && (info = (UIManager.LookAndFeelInfo)this._lafsByClassName.get(selectedLafClassName)) != null) {
            this.setSelectedLookAndFeelName(info.getName());
        }
    }

    private void generateLookAndFeelInfo() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        this._lafsByName = new TreeMap();
        for (int i = 0; i < info.length; ++i) {
            this._lafsByName.put(info[i].getName(), info[i]);
            this._lafsByClassName.put(info[i].getClassName(), info[i]);
        }
        Iterator it = this._lafsByName.values().iterator();
        while (it.hasNext()) {
            this.addItem(((UIManager.LookAndFeelInfo)it.next()).getName());
        }
    }
}

