/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.MyTableModel;

public class SortableTableModel
extends AbstractTableModel {
    private MyTableModelListener _actualModelLis = new MyTableModelListener();
    protected int _iColumn = -1;
    protected boolean _bAscending;
    private TableModel _actualModel;
    private Integer[] _indexes = new Integer[0];

    public TableModel getActualModel() {
        return this._actualModel;
    }

    public SortableTableModel() {
        this(null);
    }

    public SortableTableModel(TableModel model) {
        this.setActualModel(model);
    }

    public void setActualModel(TableModel newModel) {
        if (this._actualModel != null) {
            this._actualModel.removeTableModelListener(this._actualModelLis);
        }
        this._actualModel = newModel;
        if (this._actualModel != null) {
            this._actualModel.addTableModelListener(this._actualModelLis);
        }
    }

    public int getRowCount() {
        return this._actualModel != null ? this._actualModel.getRowCount() : 0;
    }

    public int getColumnCount() {
        return this._actualModel != null ? this._actualModel.getColumnCount() : 0;
    }

    public Object getValueAt(int row, int col) {
        return this._actualModel.getValueAt(this._indexes[row], col);
    }

    public void setValueAt(Object value, int row, int col) {
        this._actualModel.setValueAt(value, this._indexes[row], col);
    }

    public String getColumnName(int col) {
        return this._actualModel.getColumnName(col);
    }

    public Class getColumnClass(int col) {
        return this._actualModel.getColumnClass(col);
    }

    public void deleteRows(int[] rows) {
        int[] actualRows = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            actualRows[i] = this._indexes[rows[i]];
        }
        ((MyTableModel)this._actualModel).deleteRows(actualRows);
    }

    public void insertRow(Object[] values) {
        ((MyTableModel)this._actualModel).addRow(values);
        ((MyTableModel)this._actualModel).fireTableChanged(new TableModelEvent(this._actualModel));
        this.fireTableChanged(new TableModelEvent(this));
    }

    public boolean isCellEditable(int row, int col) {
        return this._actualModel.isCellEditable(row, col);
    }

    public boolean sortByColumn(int column) {
        boolean b = true;
        if (column == this._iColumn) {
            b = !this._bAscending;
        }
        this.sortByColumn(column, b);
        return b;
    }

    public void sortByColumn(int column, boolean ascending) {
        this._iColumn = column;
        this._bAscending = ascending;
        TableModelComparator comparator = new TableModelComparator(column, ascending);
        Arrays.sort(this._indexes, comparator);
        this.fireTableDataChanged();
    }

    static /* synthetic */ Integer[] access$102(SortableTableModel x0, Integer[] x1) {
        x0._indexes = x1;
        return x1;
    }

    protected class MyTableModelListener
    implements TableModelListener {
        protected MyTableModelListener() {
        }

        public void tableChanged(TableModelEvent evt) {
            SortableTableModel.access$102(SortableTableModel.this, new Integer[SortableTableModel.this.getRowCount()]);
            for (int i = 0; i < SortableTableModel.this._indexes.length; ++i) {
                ((SortableTableModel)SortableTableModel.this)._indexes[i] = new Integer(i);
            }
        }
    }

    class TableModelComparator
    implements Comparator {
        private int _iColumn;
        private int _iAscending;

        public TableModelComparator(int iColumn) {
            this(iColumn, true);
        }

        public TableModelComparator(int iColumn, boolean ascending) {
            this._iColumn = iColumn;
            this._iAscending = ascending ? 1 : -1;
        }

        public int compare(Object o1, Object o2) {
            Integer i1 = (Integer)o1;
            Integer i2 = (Integer)o2;
            Object data1 = SortableTableModel.this._actualModel.getValueAt(i1, this._iColumn);
            Object data2 = SortableTableModel.this._actualModel.getValueAt(i2, this._iColumn);
            try {
                if (data1 == null && data2 == null) {
                    return 0;
                }
                if (data1 == null) {
                    return 1 * this._iAscending;
                }
                if (data2 == null) {
                    return -1 * this._iAscending;
                }
                Comparable c1 = (Comparable)data1;
                return c1.compareTo(data2) * this._iAscending;
            }
            catch (ClassCastException ex) {
                return data1.toString().compareTo(data2.toString()) * this._iAscending;
            }
        }
    }
}

