/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;

public class DatabaseObjectInfo
implements IDatabaseObjectInfo {
    private final String _catalog;
    private final String _schema;
    private final String _simpleName;
    private final String _qualifiedName;
    private DatabaseObjectType _dboType = DatabaseObjectType.OTHER;

    public DatabaseObjectInfo(String catalog, String schema, String simpleName, DatabaseObjectType dboType, SQLDatabaseMetaData md) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        if (md == null) {
            throw new IllegalArgumentException("Null SQLDatabaseMetaData passed");
        }
        this._catalog = catalog;
        this._schema = schema;
        this._simpleName = simpleName;
        this._qualifiedName = this.generateQualifiedName(md);
        this._dboType = dboType;
    }

    public String toString() {
        return this.getSimpleName();
    }

    public String getCatalogName() {
        return this._catalog;
    }

    public String getSchemaName() {
        return this._schema;
    }

    public String getSimpleName() {
        return this._simpleName;
    }

    public String getQualifiedName() {
        return this._qualifiedName;
    }

    public DatabaseObjectType getDatabaseObjectType() {
        return this._dboType;
    }

    protected String generateQualifiedName(SQLConnection conn) {
        return this.generateQualifiedName(conn.getSQLMetaData());
    }

    protected String generateQualifiedName(SQLDatabaseMetaData md) {
        String catSep = null;
        String identifierQuoteString = null;
        boolean supportsSchemasInDataManipulation = false;
        boolean supportsCatalogsInDataManipulation = false;
        try {
            supportsSchemasInDataManipulation = md.supportsSchemasInDataManipulation();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        try {
            supportsCatalogsInDataManipulation = md.supportsCatalogsInDataManipulation();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        try {
            if (supportsCatalogsInDataManipulation) {
                catSep = md.getCatalogSeparator();
            }
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        try {
            identifierQuoteString = md.getIdentifierQuoteString();
            if (identifierQuoteString != null && identifierQuoteString.equals(" ")) {
                identifierQuoteString = null;
            }
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer();
        if (catSep != null && catSep.length() > 0 && this._catalog != null && this._catalog.length() > 0) {
            if (identifierQuoteString != null) {
                buf.append(identifierQuoteString);
            }
            buf.append(this._catalog);
            if (identifierQuoteString != null) {
                buf.append(identifierQuoteString);
            }
            buf.append(catSep);
        }
        if (supportsSchemasInDataManipulation && this._schema != null && this._schema.length() > 0) {
            if (identifierQuoteString != null) {
                buf.append(identifierQuoteString);
            }
            buf.append(this._schema);
            if (identifierQuoteString != null) {
                buf.append(identifierQuoteString);
            }
            buf.append(".");
        }
        if (identifierQuoteString != null) {
            buf.append(identifierQuoteString);
        }
        buf.append(this._simpleName);
        if (identifierQuoteString != null) {
            buf.append(identifierQuoteString);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatabaseObjectInfo) {
            DatabaseObjectInfo info = (DatabaseObjectInfo)obj;
            if ((info._catalog == null && this._catalog == null || info._catalog != null && this._catalog != null && info._catalog.equals(this._catalog)) && (info._qualifiedName == null && this._qualifiedName == null || info._qualifiedName != null && this._qualifiedName != null && info._qualifiedName.equals(this._qualifiedName)) && (info._schema == null && this._schema == null || info._schema != null && this._schema != null && info._schema.equals(this._schema))) {
                return info._simpleName == null && this._simpleName == null || info._simpleName != null && this._simpleName != null && info._simpleName.equals(this._simpleName);
            }
        }
        return false;
    }

    public int compareTo(Object o) {
        DatabaseObjectInfo other = (DatabaseObjectInfo)o;
        return this._qualifiedName.compareTo(other._qualifiedName);
    }

    public static interface IPropertyNames {
        public static final String CATALOG_NAME = "catalogName";
        public static final String SCHEMA_NAME = "schemaName";
        public static final String SIMPLE_NAME = "simpleName";
        public static final String QUALIFIED_NAME = "qualifiedName";
    }
}

