/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.util.StringTokenizer;

public class QueryTokenizer {
    private final String _querySep;
    private String _sQuerys;
    private String _sNextQuery;
    private String _solComment;

    public QueryTokenizer(String sql, String querySep, String solComment) {
        this._querySep = querySep;
        this._solComment = solComment != null && solComment.trim().length() > 0 ? solComment : null;
        if (sql != null) {
            this._sQuerys = this.prepareSQL(sql);
            this._sNextQuery = this.parse();
        } else {
            this._sQuerys = "";
        }
    }

    public boolean hasQuery() {
        return this._sNextQuery != null;
    }

    public String nextQuery() {
        String sReturnQuery = this._sNextQuery;
        this._sNextQuery = this.parse();
        return sReturnQuery;
    }

    public String parse() {
        if (this._sQuerys.length() == 0) {
            return null;
        }
        int iQuoteCount = 1;
        int iIndex1 = -1;
        while (iQuoteCount % 2 != 0) {
            iQuoteCount = 0;
            iIndex1 = this._sQuerys.indexOf(this._querySep, iIndex1 + this._querySep.length());
            while (-1 != iIndex1) {
                boolean isSep;
                boolean bl = isSep = !(0 != iIndex1 && !Character.isWhitespace(this._sQuerys.charAt(iIndex1 - 1)) || this._sQuerys.length() - this._querySep.length() != iIndex1 && !Character.isWhitespace(this._sQuerys.charAt(iIndex1 + this._querySep.length())));
                if (!(isSep || this._querySep.length() != 1 || iIndex1 != this._sQuerys.length() - 1 && this._sQuerys.charAt(iIndex1 + 1) != '\n' && this._sQuerys.charAt(iIndex1 + 1) != '\r')) {
                    isSep = true;
                }
                if (isSep) break;
                iIndex1 = this._sQuerys.indexOf(this._querySep, iIndex1 + this._querySep.length());
            }
            if (iIndex1 != -1) {
                int iIndex2 = this._sQuerys.lastIndexOf(39, iIndex1);
                while (iIndex2 != -1) {
                    if (this._sQuerys.charAt(iIndex2 - 1) != '\\') {
                        ++iQuoteCount;
                    }
                    iIndex2 = this._sQuerys.lastIndexOf(39, iIndex2 - 1);
                }
                continue;
            }
            String sNextQuery = this._sQuerys;
            this._sQuerys = "";
            if (this._solComment != null && sNextQuery.startsWith(this._solComment)) {
                return this.parse();
            }
            return this.replaceLineFeeds(sNextQuery);
        }
        String sNextQuery = this._sQuerys.substring(0, iIndex1);
        this._sQuerys = this._sQuerys.substring(iIndex1 + this._querySep.length()).trim();
        if (this._solComment != null && sNextQuery.startsWith(this._solComment)) {
            return this.parse();
        }
        return this.replaceLineFeeds(sNextQuery);
    }

    private String prepareSQL(String sql) {
        StringBuffer results = new StringBuffer(1024);
        StringTokenizer tok = new StringTokenizer(sql.trim(), "\n", false);
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            if (line.startsWith(this._solComment)) continue;
            results.append(line).append('\n');
        }
        return results.toString();
    }

    private String replaceLineFeeds(String sql) {
        StringBuffer sbReturn = new StringBuffer();
        int iPrev = 0;
        int linefeed = sql.indexOf(10);
        int iQuote = -1;
        while (linefeed != -1) {
            if ((iQuote = sql.indexOf(39, iQuote + 1)) != -1 && iQuote < linefeed) {
                int iNextQute = sql.indexOf(39, iQuote + 1);
                if (iNextQute <= linefeed) continue;
                sbReturn.append(sql.substring(iPrev, linefeed));
                sbReturn.append('\n');
                iPrev = linefeed + 1;
                linefeed = sql.indexOf(10, iPrev);
                continue;
            }
            linefeed = sql.indexOf(10, linefeed + 1);
        }
        sbReturn.append(sql.substring(iPrev));
        return sbReturn.toString();
    }
}

