/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverClassLoader;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLDriverManager {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$sql$SQLDriverManager == null ? (class$net$sourceforge$squirrel_sql$fw$sql$SQLDriverManager = SQLDriverManager.class$("net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager")) : class$net$sourceforge$squirrel_sql$fw$sql$SQLDriverManager);
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$sql$SQLDriverManager == null ? (class$net$sourceforge$squirrel_sql$fw$sql$SQLDriverManager = SQLDriverManager.class$("net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager")) : class$net$sourceforge$squirrel_sql$fw$sql$SQLDriverManager);
    private Map _driverInfo = new HashMap();
    private Map _classLoaders = new HashMap();
    private MyDriverListener _myDriverListener = new MyDriverListener();
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$SQLDriverManager;

    public synchronized void registerSQLDriver(ISQLDriver sqlDriver) throws IllegalAccessException, InstantiationException, ClassNotFoundException, MalformedURLException {
        this.unregisterSQLDriver(sqlDriver);
        sqlDriver.addPropertyChangeListener(this._myDriverListener);
        SQLDriverClassLoader loader = new SQLDriverClassLoader(sqlDriver);
        Class<?> driverClass = loader.loadClass(sqlDriver.getDriverClassName());
        this._driverInfo.put(sqlDriver.getIdentifier(), driverClass.newInstance());
        this._classLoaders.put(sqlDriver.getIdentifier(), loader);
        sqlDriver.setJDBCDriverClassLoaded(true);
    }

    public synchronized void unregisterSQLDriver(ISQLDriver sqlDriver) {
        sqlDriver.setJDBCDriverClassLoaded(false);
        sqlDriver.removePropertyChangeListener(this._myDriverListener);
        this._driverInfo.remove(sqlDriver.getIdentifier());
        this._classLoaders.remove(sqlDriver.getIdentifier());
    }

    public SQLConnection getConnection(ISQLDriver sqlDriver, ISQLAlias alias, String user, String pw) throws ClassNotFoundException, IllegalAccessException, InstantiationException, MalformedURLException, SQLException {
        return this.getConnection(sqlDriver, alias, user, pw, null);
    }

    public synchronized SQLConnection getConnection(ISQLDriver sqlDriver, ISQLAlias alias, String user, String pw, SQLDriverPropertyCollection props) throws ClassNotFoundException, IllegalAccessException, InstantiationException, MalformedURLException, SQLException {
        Connection jdbcConn;
        Driver driver;
        Properties myProps = new Properties();
        if (props != null) {
            props.applyTo(myProps);
        }
        if (user != null) {
            myProps.put("user", user);
        }
        if (pw != null) {
            myProps.put("password", pw);
        }
        if ((driver = (Driver)this._driverInfo.get(sqlDriver.getIdentifier())) == null) {
            s_log.debug("Loading driver that wasn't registered: " + sqlDriver.getDriverClassName());
            SQLDriverClassLoader loader = new SQLDriverClassLoader(sqlDriver);
            Class<?> driverCls = loader.loadClass(sqlDriver.getDriverClassName());
            driver = (Driver)driverCls.newInstance();
        }
        if ((jdbcConn = driver.connect(alias.getUrl(), myProps)) == null) {
            throw new SQLException(s_stringMgr.getString("SQLDriverManager.error.noconnection"));
        }
        return new SQLConnection(jdbcConn, props);
    }

    public Driver getJDBCDriver(IIdentifier id) {
        if (id == null) {
            throw new IllegalArgumentException("IIdentifier == null");
        }
        return (Driver)this._driverInfo.get(id);
    }

    public SQLDriverClassLoader getSQLDriverClassLoader(ISQLDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("SQLDriverClassLoader == null");
        }
        return (SQLDriverClassLoader)this._classLoaders.get(driver.getIdentifier());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class MyDriverListener
    implements PropertyChangeListener {
        private MyDriverListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || propName.equals("driverClassName") || propName.equals("jarFileNames")) {
                Object obj = evt.getSource();
                if (obj instanceof ISQLDriver) {
                    ISQLDriver driver = (ISQLDriver)obj;
                    SQLDriverManager.this.unregisterSQLDriver(driver);
                    try {
                        SQLDriverManager.this.registerSQLDriver(driver);
                    }
                    catch (IllegalAccessException ex) {
                        s_log.error("Unable to create instance of Class " + driver.getDriverClassName() + " for JDCB driver " + driver.getName(), ex);
                    }
                    catch (InstantiationException ex) {
                        s_log.error("Unable to create instance of Class " + driver.getDriverClassName() + " for JDCB driver " + driver.getName(), ex);
                    }
                    catch (MalformedURLException ex) {
                        s_log.error("Unable to create instance of Class " + driver.getDriverClassName() + " for JDCB driver " + driver.getName(), ex);
                    }
                    catch (ClassNotFoundException ex) {
                        s_log.error("Unable to find Driver Class " + driver.getDriverClassName() + " for JDCB driver " + driver.getName());
                    }
                } else {
                    s_log.error("SqlDriverManager.MyDriverListener is listening to a non-ISQLDriver");
                }
            }
        }
    }
}

