/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class StringManager {
    private static ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$util$StringManager == null ? (class$net$sourceforge$squirrel_sql$fw$util$StringManager = StringManager.class$("net.sourceforge.squirrel_sql.fw.util.StringManager")) : class$net$sourceforge$squirrel_sql$fw$util$StringManager);
    private ResourceBundle _rsrcBundle;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$util$StringManager;

    StringManager(String packageName, ClassLoader loader) {
        this._rsrcBundle = ResourceBundle.getBundle(packageName + ".I18NStrings", Locale.getDefault(), loader);
    }

    public String getString(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        try {
            return this._rsrcBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            String msg = "No resource string found for key '" + key + "'";
            s_log.error(msg);
            return msg;
        }
    }

    public String getString(String key, Object arg) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        Object[] args = arg == null ? new Object[]{} : new Object[]{arg};
        return this.getString(key, args);
    }

    public String getString(String key, Object[] args) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (args == null) {
            args = new Object[]{};
        }
        String str = this.getString(key);
        try {
            return MessageFormat.format(str, args);
        }
        catch (IllegalArgumentException ex) {
            String msg = "Error formatting i18 string. Key is '" + key + "'";
            s_log.error(msg, ex);
            return msg + ": " + ex.toString();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

