/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class SortedList
extends AbstractList {
    protected int _size;
    protected Object[] _data;
    protected Comparator _comp;
    private int _index;

    public SortedList(Comparator comp) {
        this._comp = comp;
        this._data = new Object[25];
    }

    public SortedList(Comparator comp, Collection collection) {
        this._comp = comp;
        this._data = new Object[collection.size() + 25];
        this.addAll(collection);
    }

    public Object get(int index) {
        return this._data[index];
    }

    public int size() {
        return this._size;
    }

    public boolean add(Object o) {
        int index = this.indexOfIntern(o);
        if (index < 0) {
            index = -(index + 1);
        }
        try {
            if (index != this._size) {
                System.arraycopy(this._data, index, this._data, index + 1, this._size - index);
            }
            this._data[index] = o;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Object[] data = new Object[this._size + 25];
            System.arraycopy(this._data, 0, data, 0, index);
            System.arraycopy(this._data, index, data, index + 1, this._size - index);
            data[index] = o;
            this._data = data;
        }
        this._index = index;
        ++this._size;
        return true;
    }

    public void addAll(Iterator it) {
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public int getInsertIndex() {
        return this._index;
    }

    public int indexOf(Object o) {
        int index = this.indexOfIntern(o);
        return index < 0 ? -1 : index;
    }

    protected int indexOfIntern(Object o) {
        int low = 0;
        int high = this._size - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = this._data[mid];
            int cmp = this._comp.compare(midVal, o);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public boolean contains(Object o) {
        return this.indexOfIntern(o) >= 0;
    }

    public Object remove(int index) {
        if (index >= this._size || index < 0) {
            throw new ArrayIndexOutOfBoundsException("index greater then size or below zero for remove " + index);
        }
        Object data = this._data[index];
        System.arraycopy(this._data, index + 1, this._data, index, this._size - index - 1);
        --this._size;
        return data;
    }

    public boolean remove(Object o) {
        int index = this.indexOfIntern(o);
        if (index >= 0) {
            this.remove(index);
        }
        return index >= 0;
    }
}

