/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.actions.editdialog;

import com.sun.rowset.JdbcRowSetImpl;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.RowSet;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbviewer.actions.editdialog.SQLComposite;
import net.sourceforge.sqlexplorer.dbviewer.actions.editdialog.SqlTableLabelProvider;
import net.sourceforge.sqlexplorer.dbviewer.actions.editdialog.SqlTableModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class EditorDialog
extends TitleAreaDialog {
    SessionTreeNode sessionNode;
    TableNode node;
    String[] columns;
    SQLComposite sqlComp;
    SqlTableModel mo;
    ResultSetMetaData metaData;
    RowSet rowSet;
    ResultSet rs;
    String oldCatalog = null;
    String whereCondition = "";

    public EditorDialog(SessionTreeNode sessionNode, TableNode node) throws SQLException {
        super(null);
        this.node = node;
        this.sessionNode = sessionNode;
        if (sessionNode.supportsCatalogs()) {
            this.oldCatalog = sessionNode.getCatalog();
            sessionNode.setCatalog(node.getTableInfo().getCatalogName());
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Editing " + this.node.getTableInfo().getQualifiedName());
        this.setMessage(Messages.getString("EditorDialog.Note__the_Direct_Table_Editing_is_an_experimental_feature._1"));
        return contents;
    }

    RowSet getRowSet(SQLConnection conn, String baseTable) throws SQLException {
        Statement stmt = null;
        String sql = null;
        sql = conn.getSQLMetaData().getDatabaseProductName().toLowerCase().startsWith("oracle") ? "select aaalias.* from " + baseTable + " aaalias " + this.whereCondition : "select * from " + baseTable + " " + this.whereCondition;
        if (this.rs != null) {
            try {
                this.rs.close();
                this.rs.getStatement().close();
            }
            catch (Throwable throwable) {}
        }
        if (this.rowSet != null) {
            try {
                this.rowSet.close();
                this.rowSet.getStatement().close();
            }
            catch (Throwable throwable) {}
        }
        stmt = conn.getConnection().createStatement(1005, 1008);
        stmt.setMaxRows(SQLExplorerPlugin.getDefault().getPreferenceStore().getInt("maxSQLRows"));
        this.rs = stmt.executeQuery(sql);
        if (this.rs.getConcurrency() != 1008) {
            throw new SQLException("The result set is not updatable");
        }
        JdbcRowSetImpl crs = new JdbcRowSetImpl(this.rs);
        crs.setReadOnly(false);
        return crs;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.sqlComp = new SQLComposite(parentComposite, 0, this);
        this.sqlComp.setLayoutData(new GridData(1808));
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                try {
                    EditorDialog.this.rowSet = EditorDialog.this.getRowSet(EditorDialog.this.sessionNode.getConnection(), EditorDialog.this.node.getTableInfo().getQualifiedName());
                    EditorDialog.this.showRowSet();
                    EditorDialog.this.sqlComp.getStatusLineManager().setMessage("");
                }
                catch (Throwable e) {
                    EditorDialog.this.rowSet = null;
                    EditorDialog.this.sqlComp.getStatusLineManager().setMessage("Error: can't edit:" + e.getMessage());
                    SQLExplorerPlugin.error("Error opening edit dialog", e);
                }
            }
        });
        return parentComposite;
    }

    public void showRowSet() throws Exception {
        if (this.rowSet != null) {
            this.metaData = this.rowSet.getMetaData();
            int count = this.metaData.getColumnCount();
            this.columns = new String[count];
            int i = 0;
            while (i < count) {
                this.columns[i] = this.metaData.getColumnName(i + 1);
                ++i;
            }
            this.mo = new SqlTableModel(this.rowSet, this.metaData);
            TableViewer tv = this.sqlComp.getTableViewer();
            Table table = tv.getTable();
            if (table.getColumnCount() == 0) {
                int i2 = 0;
                while (i2 < count) {
                    TableColumn tc = new TableColumn(table, 0);
                    tc.setText(this.columns[i2]);
                    ++i2;
                }
                tv.setColumnProperties(this.columns);
                CellEditor[] cellEditors = new CellEditor[count];
                int i3 = 0;
                while (i3 < cellEditors.length) {
                    cellEditors[i3] = new TextCellEditor((Composite)table);
                    ++i3;
                }
                tv.setCellEditors(cellEditors);
                tv.setLabelProvider((IBaseLabelProvider)new SqlTableLabelProvider(this.mo));
            }
            tv.setInput((Object)this.mo);
            int i4 = 0;
            while (i4 < count) {
                table.getColumn(i4).pack();
                ++i4;
            }
            table.layout();
            table.redraw();
            tv.refresh();
        } else {
            this.sqlComp.getTableViewer().setInput(null);
            this.sqlComp.getTableViewer().refresh();
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    int getColumnIndex(String property) {
        int index = -1;
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i].equals(property)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public void modify(final Object element, final String property, final Object value) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                int index;
                TableItem item = (TableItem)element;
                ArrayList ls = (ArrayList)EditorDialog.this.mo.getElements()[item.getParent().indexOf(item)];
                Object originalVal = ls.get(index = EditorDialog.this.getColumnIndex(property));
                if (originalVal != null && originalVal.equals(value)) {
                    EditorDialog.this.sqlComp.getStatusLineManager().setMessage(Messages.getString("EditorDialog.No_change_2"));
                    return;
                }
                try {
                    Object value_ = value;
                    if (value_.equals("<NULL>")) {
                        value_ = null;
                    }
                    EditorDialog.this.rowSet.first();
                    EditorDialog.this.rowSet.relative(item.getParent().indexOf(item));
                    EditorDialog.this.rowSet.updateObject(property, value_);
                    EditorDialog.this.rowSet.updateRow();
                    ls.set(index, value_);
                    EditorDialog.this.sqlComp.getTableViewer().refresh();
                }
                catch (Throwable e) {
                    EditorDialog.this.sqlComp.getStatusLineManager().setMessage("Error updating: " + e.getMessage());
                    return;
                }
                EditorDialog.this.sqlComp.getStatusLineManager().setMessage(Messages.getString("EditorDialog.Cell_updated_successfully_3"));
            }
        });
    }

    public boolean canModify(Object element, String property) {
        int index = this.getColumnIndex(property);
        int type = 0;
        try {
            type = this.metaData.getColumnType(index + 1);
        }
        catch (Throwable throwable) {
            return false;
        }
        return type != -3 && type != -2 && type != -4 && type != 2004 && type != 2005 && type != 1111;
    }

    public Object getValue(Object element, String property) {
        int index = this.getColumnIndex(property);
        Object val = ((ArrayList)element).get(index);
        if (val == null) {
            return "";
        }
        return val.toString();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(String.valueOf(Messages.getString("EditorDialog.Editing__5")) + this.node.getTableInfo().getSimpleName());
        super.configureShell(newShell);
    }

    public int open() {
        int val = super.open();
        if (this.rowSet != null) {
            try {
                this.rowSet.close();
            }
            catch (Throwable throwable) {}
        }
        if (this.rs != null) {
            try {
                this.rs.close();
                this.rs.getStatement().close();
            }
            catch (Throwable throwable) {}
        }
        if (this.sessionNode.supportsCatalogs() && this.oldCatalog != null) {
            try {
                this.sessionNode.setCatalog(this.oldCatalog);
            }
            catch (Throwable throwable) {}
        }
        return val;
    }

    public void updateWhereCondition(String string) {
        this.whereCondition = string;
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                try {
                    EditorDialog.this.rowSet = EditorDialog.this.getRowSet(EditorDialog.this.sessionNode.getConnection(), EditorDialog.this.node.getTableInfo().getQualifiedName());
                    EditorDialog.this.showRowSet();
                    EditorDialog.this.sqlComp.getStatusLineManager().setMessage("");
                }
                catch (Throwable e) {
                    EditorDialog.this.rowSet = null;
                    EditorDialog.this.sqlComp.getStatusLineManager().setMessage("Error: not valid sql statement:" + e.getMessage());
                    SQLExplorerPlugin.error("Error in where condition", e);
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }
}

