/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.details;

import net.sourceforge.sqlexplorer.dbviewer.details.IDetailLogDisplay;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class RowCountDetail
implements IDetailLogDisplay {
    Text textWidget;
    boolean activated = false;
    TableNode node;
    private IDetailLogDisplay detailLog;
    String errorMessage = "";
    TabItem itemTab;
    TabFolder parent;

    public void setMessage(String s) {
        this.detailLog.setMessage(s);
        this.errorMessage = s;
    }

    public RowCountDetail(TabItem itemTab, TabFolder parent, IDetailLogDisplay detailLog) {
        this.itemTab = itemTab;
        this.parent = parent;
        this.detailLog = detailLog;
    }

    public void setNode(TableNode node) {
        this.node = node;
        this.activated = false;
        if (this.textWidget != null) {
            this.itemTab.setControl(null);
            this.textWidget.dispose();
            this.textWidget = null;
        }
    }

    public void activate() {
        if (!this.activated) {
            this.activated = true;
            this.textWidget = new Text((Composite)this.parent, 2048);
            this.textWidget.setEditable(false);
            this.itemTab.setControl((Control)this.textWidget);
            Display display = this.textWidget.getDisplay();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                public void run() {
                    try {
                        RowCountDetail.this.textWidget.setText("" + RowCountDetail.this.node.getRowCount());
                    }
                    catch (Throwable e) {
                        SQLExplorerPlugin.error("Error activating preview ", e);
                        RowCountDetail.this.errorMessage = e.getMessage();
                        RowCountDetail.this.setMessage(RowCountDetail.this.errorMessage);
                    }
                    RowCountDetail.this.activated = true;
                }
            });
        } else {
            this.detailLog.setMessage(this.errorMessage);
        }
    }
}

