/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.model;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbviewer.DetailManager;
import net.sourceforge.sqlexplorer.dbviewer.model.CatalogNode;
import net.sourceforge.sqlexplorer.dbviewer.model.DatabaseNode;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.SchemaNode;
import net.sourceforge.sqlexplorer.ext.PluginManager;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import org.eclipse.swt.widgets.Composite;

public class DatabaseModel
implements IDbModel {
    private SessionTreeNode sessionNode;
    private DatabaseNode root;
    private PluginManager pm = null;
    private List auxiliaryRoot = new ArrayList(5);
    boolean supportsCatalogs = false;
    boolean supportsSchemas = false;

    public Composite getComposite(DetailManager detailManager) {
        return null;
    }

    public boolean supportsCatalogs() {
        return this.supportsCatalogs;
    }

    public boolean supportsSchemas() {
        return this.supportsSchemas;
    }

    public String[] getCatalogNames() {
        ArrayList<String> ls = new ArrayList<String>();
        int i = 0;
        while (i < this.root.children.size()) {
            if (this.root.children.get(i) instanceof CatalogNode) {
                ls.add(((CatalogNode)this.root.children.get(i)).toString());
            }
            ++i;
        }
        return ls.toArray(new String[0]);
    }

    public List getCatalogs() {
        ArrayList<CatalogNode> ls = new ArrayList<CatalogNode>();
        int i = 0;
        while (i < this.root.children.size()) {
            if (this.root.children.get(i) instanceof CatalogNode) {
                ls.add((CatalogNode)this.root.children.get(i));
            }
            ++i;
        }
        return ls;
    }

    public List getSchemas() {
        ArrayList<SchemaNode> ls = new ArrayList<SchemaNode>();
        int i = 0;
        while (i < this.root.children.size()) {
            if (this.root.children.get(i) instanceof SchemaNode) {
                ls.add((SchemaNode)this.root.children.get(i));
            }
            ++i;
        }
        return ls;
    }

    public DatabaseModel(SessionTreeNode sessionNode, PluginManager pm) {
        this.sessionNode = sessionNode;
        this.pm = pm;
        this.root = new DatabaseNode(Messages.getString("Database_1"));
        if (sessionNode == null) {
            return;
        }
        SQLDatabaseMetaData md = sessionNode.getConnection().getSQLMetaData();
        try {
            this.supportsCatalogs = md.supportsCatalogs();
        }
        catch (Exception exception) {}
        this.supportsSchemas = false;
        try {
            int i;
            this.supportsSchemas = md.supportsSchemas();
            if (this.supportsCatalogs) {
                String[] catalogs = md.getCatalogs();
                i = 0;
                while (i < catalogs.length) {
                    String catalogName = catalogs[i];
                    this.root.add(new CatalogNode(this.root, catalogName, sessionNode, pm));
                    ++i;
                }
            } else if (this.supportsSchemas) {
                String[] schemas = md.getSchemas();
                i = 0;
                while (i < schemas.length) {
                    String schemaName = schemas[i];
                    this.root.add(new SchemaNode(this.root, schemaName, sessionNode, pm));
                    ++i;
                }
            } else {
                this.root.add(new CatalogNode(this.root, Messages.getString("NoCatalog_2"), sessionNode, pm));
            }
            try {
                IDbModel[] added = sessionNode.getPluginManager().getDbRootAddedTypes(this.root, sessionNode);
                if (added != null) {
                    i = 0;
                    while (i < added.length) {
                        IDbModel added_ = added[i];
                        this.auxiliaryRoot.add(added_);
                        ++i;
                    }
                }
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Error Retrieving added root nodes in plugin ", e);
            }
        }
        catch (Throwable ex) {
            SQLExplorerPlugin.error("error creating database model ", ex);
        }
    }

    public Object[] getChildren() {
        if (this.auxiliaryRoot.size() == 0) {
            return new Object[]{this.root};
        }
        ArrayList<DatabaseNode> ls = new ArrayList<DatabaseNode>();
        ls.addAll(this.auxiliaryRoot);
        ls.add(0, this.root);
        return ls.toArray();
    }

    public Object getParent() {
        return null;
    }
}

