/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dialogs;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.MyURLClassLoader;
import net.sourceforge.sqlexplorer.dialogs.ClassPathListModel;
import net.sourceforge.sqlexplorer.dialogs.DefaultFileListBoxModel;
import net.sourceforge.sqlexplorer.dialogs.FileContentProvider;
import net.sourceforge.sqlexplorer.dialogs.FileLabelProvider;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CreateDriverDlg
extends TitleAreaDialog {
    private DriverModel driverModel;
    private ISQLDriver driver;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    Button _extraClasspathDeleteBtn;
    private Button _extraClasspathUpBtn;
    private Button _extraClasspathDownBtn;
    private Button newBtn;
    Button _javaClasspathListDriversBtn;
    Button _extraClasspathListDriversBtn;
    DefaultFileListBoxModel defaultModel = new DefaultFileListBoxModel();
    ListViewer extraClassPathList;
    ListViewer javaClassPathList;
    int type;
    Text nameField;
    Button jarSearch;
    Combo combo;
    Text exampleUrlField;
    static /* synthetic */ Class class$0;

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    public CreateDriverDlg(Shell parentShell, DriverModel dm, int type, ISQLDriver dv) {
        super(parentShell);
        this.driverModel = dm;
        this.driver = dv;
        this.type = type;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.type == 1) {
            shell.setText(Messages.getString("Create_new_Driver_!_2"));
        } else if (this.type == 2) {
            shell.setText(Messages.getString("Modify_Driver_!_3"));
        } else if (this.type == 3) {
            shell.setText(Messages.getString("Copy_Driver_!_4"));
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.type == 1) {
            this.setTitle(Messages.getString("New_Driver_6"));
            this.setMessage(Messages.getString("Create_a_new_driver_7"));
        } else if (this.type == 2) {
            this.setTitle(Messages.getString("Modify_driver_8"));
            this.setMessage(Messages.getString("Modify_the_driver_9"));
        } else if (this.type == 3) {
            this.setTitle(Messages.getString("Copy_Driver_10"));
            this.setMessage(Messages.getString("Copy_the_driver_11"));
        }
        return contents;
    }

    protected void okPressed() {
        String name = this.nameField.getText().trim();
        String driverClassName = this.combo.getText();
        driverClassName = driverClassName != null ? driverClassName.trim() : "";
        String url = this.exampleUrlField.getText().trim();
        (new String[1])[0] = IDialogConstants.OK_LABEL;
        if (name.equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("Error..._2"), (String)"Name is empty");
            return;
        }
        if (driverClassName.equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("Error..._2"), (String)"Driver Class Name is empty");
            return;
        }
        if (url.equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("Error..._2"), (String)"URL is empty");
            return;
        }
        try {
            this.driver.setName(name);
            this.driver.setJarFileNames(this.defaultModel.getFileNames());
            this.driver.setDriverClassName(driverClassName);
            this.driver.setUrl(url);
            if (this.type == 1 || this.type == 3) {
                this.driverModel.addDriver(this.driver);
            }
        }
        catch (ValidationException excp) {
            SQLExplorerPlugin.error("Validation Exception", excp);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("Error..._2"), (String)Messages.getString("Error_Validation_Exception_12"));
        }
        catch (DuplicateObjectException excp1) {
            SQLExplorerPlugin.error("Duplicate Exception", excp1);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("Error..._2"), (String)Messages.getString("Error_DuplicateObjectException_13"));
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Exception when adding driver", e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("Error..._2"), (String)("Error Adding Driver:" + e.getMessage()));
        }
        this.close();
    }

    void validate() {
        if (this.nameField.getText().trim().length() > 0 && this.exampleUrlField.getText().trim().length() > 0 && this.combo.getText().trim().length() > 0) {
            this.setDialogComplete(true);
        } else {
            this.setDialogComplete(false);
        }
    }

    protected void setDialogComplete(boolean value) {
        Button okBtn = this.getButton(0);
        if (okBtn != null) {
            okBtn.setEnabled(value);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Composite nameGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        nameGroup.setLayoutData((Object)data);
        Composite topComposite = new Composite(nameGroup, 0);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        topComposite.setLayoutData((Object)data);
        topComposite.setLayout((Layout)new GridLayout());
        Group topGroup = new Group(topComposite, 0);
        topGroup.setText(Messages.getString("Driver_14"));
        data = new GridData(1808);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        topGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 5;
        topGroup.setLayout((Layout)layout);
        Label label = new Label((Composite)topGroup, 64);
        label.setText(Messages.getString("Name_15"));
        this.nameField = new Text((Composite)topGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.nameField.setLayoutData((Object)data);
        this.nameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CreateDriverDlg.this.validate();
            }

            public void keyReleased(KeyEvent e) {
                CreateDriverDlg.this.validate();
            }
        });
        Label label5 = new Label((Composite)topGroup, 64);
        label5.setText(Messages.getString("Example_URL_16"));
        this.exampleUrlField = new Text((Composite)topGroup, 2048);
        data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.exampleUrlField.setLayoutData((Object)data);
        this.exampleUrlField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CreateDriverDlg.this.validate();
            }

            public void keyReleased(KeyEvent e) {
                CreateDriverDlg.this.validate();
            }
        });
        Composite centralComposite = new Composite(nameGroup, 0);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 4;
        data.heightHint = 200;
        centralComposite.setLayoutData((Object)data);
        centralComposite.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder(centralComposite, 0);
        TabItem item1 = new TabItem(tabFolder, 0);
        item1.setText(Messages.getString("Java_Class_Path_17"));
        TabItem item2 = new TabItem(tabFolder, 0);
        item2.setText(Messages.getString("Extra_Class_Path_18"));
        this.createJavaClassPathPanel(tabFolder, item1);
        this.createExtraClassPathPanel(tabFolder, item2);
        Label label4 = new Label(nameGroup, 64);
        label4.setText(Messages.getString("Driver_Class_Name_19"));
        this.combo = new Combo(nameGroup, 2052);
        data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.combo.setLayoutData((Object)data);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CreateDriverDlg.this.validate();
            }
        });
        this.combo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CreateDriverDlg.this.validate();
            }

            public void keyReleased(KeyEvent e) {
                CreateDriverDlg.this.validate();
            }
        });
        nameGroup.layout();
        this.loadData();
        return parentComposite;
    }

    private void loadData() {
        this.nameField.setText(this.driver.getName());
        if (this.driver.getDriverClassName() != null) {
            this.combo.setText(this.driver.getDriverClassName());
        }
        this.exampleUrlField.setText(this.driver.getUrl());
        String[] fileNames = this.driver.getJarFileNames();
        int i = 0;
        while (i < fileNames.length) {
            this.defaultModel.addFile(new File(fileNames[i]));
            ++i;
        }
        if (this.extraClassPathList != null) {
            this.extraClassPathList.refresh();
            if (this.defaultModel.size() > 0) {
                this.extraClassPathList.getList().setSelection(0);
            }
        }
        if (this.defaultModel.size() > 0) {
            Object obj = this.defaultModel.toArray()[0];
            StructuredSelection sel = new StructuredSelection(obj);
            this.extraClassPathList.setSelection((ISelection)sel);
        }
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    private void createJavaClassPathPanel(TabFolder tabFolder, TabItem tabItem) {
        Composite parent = new Composite((Composite)tabFolder, 0);
        parent.setLayout((Layout)new FillLayout());
        tabItem.setControl((Control)parent);
        Composite cmp = new Composite(parent, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        cmp.setLayout((Layout)grid);
        this.javaClassPathList = new ListViewer(cmp, 2816);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.javaClassPathList.getControl().setLayoutData((Object)data);
        this.javaClassPathList.setContentProvider((IContentProvider)new FileContentProvider());
        this.javaClassPathList.setLabelProvider((IBaseLabelProvider)new FileLabelProvider());
        ClassPathListModel model = new ClassPathListModel();
        this.javaClassPathList.setInput((Object)model);
        Composite left = new Composite(cmp, 0);
        data = new GridData();
        data.horizontalSpan = 1;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 100;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        left.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        left.setLayout((Layout)gridLayout);
        this._javaClasspathListDriversBtn = new Button(left, 0);
        this._javaClasspathListDriversBtn.setText(Messages.getString("List_Drivers_20"));
        this._javaClasspathListDriversBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateDriverDlg.this.combo.removeAll();
                File file = (File)((IStructuredSelection)CreateDriverDlg.this.javaClassPathList.getSelection()).getFirstElement();
                if (file != null) {
                    try {
                        MyURLClassLoader cl = new MyURLClassLoader(file.toURL());
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("java.sql.Driver");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Class[] classes = cl.getAssignableClasses(clazz);
                        int i = 0;
                        while (i < classes.length) {
                            CreateDriverDlg.this.combo.add(classes[i].getName());
                            ++i;
                        }
                    }
                    catch (MalformedURLException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (CreateDriverDlg.this.combo.getItemCount() > 0) {
                    CreateDriverDlg.this.combo.setText(CreateDriverDlg.this.combo.getItem(0));
                }
            }
        });
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._javaClasspathListDriversBtn.setLayoutData((Object)data);
        this.javaClassPathList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                File f = (File)selection.getFirstElement();
                if (f != null) {
                    if (f.isFile()) {
                        CreateDriverDlg.this._javaClasspathListDriversBtn.setEnabled(true);
                    } else {
                        CreateDriverDlg.this._javaClasspathListDriversBtn.setEnabled(false);
                    }
                } else {
                    CreateDriverDlg.this._javaClasspathListDriversBtn.setEnabled(false);
                }
            }
        });
        if (model.size() > 0) {
            Object obj = model.toArray()[0];
            StructuredSelection sel = new StructuredSelection(obj);
            this.javaClassPathList.setSelection((ISelection)sel);
        }
    }

    private void createExtraClassPathPanel(final TabFolder tabFolder, TabItem tabItem) {
        Composite parent = new Composite((Composite)tabFolder, 0);
        parent.setLayout((Layout)new FillLayout());
        tabItem.setControl((Control)parent);
        Composite cmp = new Composite(parent, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        cmp.setLayout((Layout)grid);
        this.extraClassPathList = new ListViewer(cmp, 2816);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.extraClassPathList.getControl().setLayoutData((Object)data);
        this.extraClassPathList.setContentProvider((IContentProvider)new FileContentProvider());
        this.extraClassPathList.setLabelProvider((IBaseLabelProvider)new FileLabelProvider());
        this.extraClassPathList.setInput((Object)this.defaultModel);
        Composite left = new Composite(cmp, 0);
        data = new GridData();
        data.horizontalSpan = 1;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 100;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        left.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        left.setLayout((Layout)gridLayout);
        this._extraClasspathListDriversBtn = new Button(left, 0);
        this._extraClasspathListDriversBtn.setText(Messages.getString("List_Drivers_21"));
        this._extraClasspathListDriversBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateDriverDlg.this.combo.removeAll();
                File file = (File)((IStructuredSelection)CreateDriverDlg.this.extraClassPathList.getSelection()).getFirstElement();
                if (file != null) {
                    try {
                        MyURLClassLoader cl = new MyURLClassLoader(file.toURL());
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("java.sql.Driver");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Class[] classes = cl.getAssignableClasses(clazz);
                        int i = 0;
                        while (i < classes.length) {
                            CreateDriverDlg.this.combo.add(classes[i].getName());
                            ++i;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (IOException iOException) {}
                }
                if (CreateDriverDlg.this.combo.getItemCount() > 0) {
                    CreateDriverDlg.this.combo.setText(CreateDriverDlg.this.combo.getItem(0));
                }
            }
        });
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._extraClasspathListDriversBtn.setLayoutData((Object)data);
        this._extraClasspathUpBtn = new Button(left, 0);
        this._extraClasspathUpBtn.setText(Messages.getString("Up_22"));
        this._extraClasspathUpBtn.setEnabled(false);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._extraClasspathUpBtn.setLayoutData((Object)data);
        this._extraClasspathDownBtn = new Button(left, 0);
        this._extraClasspathDownBtn.setText(Messages.getString("Down_23"));
        this._extraClasspathDownBtn.setEnabled(false);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._extraClasspathDownBtn.setLayoutData((Object)data);
        this.newBtn = new Button(left, 0);
        this.newBtn.setText(Messages.getString("New_24"));
        this.newBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(tabFolder.getShell(), 4096);
                dlg.setFilterExtensions(new String[]{"*.jar;*.zip"});
                String str = dlg.open();
                if (str != null) {
                    File obj = new File(str);
                    CreateDriverDlg.this.defaultModel.add(obj);
                    CreateDriverDlg.this.extraClassPathList.refresh();
                    StructuredSelection sel = new StructuredSelection((Object)obj);
                    CreateDriverDlg.this.extraClassPathList.setSelection((ISelection)sel);
                }
            }
        });
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.newBtn.setLayoutData((Object)data);
        this._extraClasspathDeleteBtn = new Button(left, 0);
        this._extraClasspathDeleteBtn.setText(Messages.getString("Delete_26"));
        this._extraClasspathDeleteBtn.setEnabled(false);
        this._extraClasspathDeleteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                File f = (File)((IStructuredSelection)CreateDriverDlg.this.extraClassPathList.getSelection()).getFirstElement();
                if (f != null) {
                    CreateDriverDlg.this.defaultModel.remove(f);
                    CreateDriverDlg.this.extraClassPathList.refresh();
                    if (CreateDriverDlg.this.defaultModel.size() > 0) {
                        Object obj = CreateDriverDlg.this.defaultModel.toArray()[0];
                        StructuredSelection sel = new StructuredSelection(obj);
                        CreateDriverDlg.this.extraClassPathList.setSelection((ISelection)sel);
                    }
                }
            }
        });
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._extraClasspathDeleteBtn.setLayoutData((Object)data);
        this.extraClassPathList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                File f = (File)selection.getFirstElement();
                if (f != null) {
                    CreateDriverDlg.this._extraClasspathDeleteBtn.setEnabled(true);
                    CreateDriverDlg.this._extraClasspathListDriversBtn.setEnabled(true);
                } else {
                    CreateDriverDlg.this._extraClasspathListDriversBtn.setEnabled(false);
                    CreateDriverDlg.this._extraClasspathDeleteBtn.setEnabled(false);
                }
            }
        });
    }
}

