/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dialogs;

import java.net.URL;
import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.IdentifierFactory;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dialogs.CreateDriverDlg;
import net.sourceforge.sqlexplorer.dialogs.DriverContentProvider;
import net.sourceforge.sqlexplorer.dialogs.DriverLabelProvider;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;

public class DriverContainerGroup
extends Composite {
    TableViewer tableViewer;
    Action newDriver;
    Action changeDriver;
    Action copyDriver;
    Action deleteDriver;
    DriverModel driverModel;

    private void createActions() {
        this.newDriver = new Action(){
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getCreateDriverIcon());

            public String getToolTipText() {
                return Messages.getString("Create_new_Driver_6");
            }

            public String getText() {
                return Messages.getString("Create_new_Driver_6");
            }

            public ImageDescriptor getHoverImageDescriptor() {
                return this.img;
            }

            public ImageDescriptor getImageDescriptor() {
                return this.img;
            }

            public void run() {
                IdentifierFactory factory = IdentifierFactory.getInstance();
                ISQLDriver driver = DriverContainerGroup.this.driverModel.createDriver(factory.createIdentifier());
                CreateDriverDlg dlg = new CreateDriverDlg(DriverContainerGroup.this.getShell(), DriverContainerGroup.this.driverModel, 1, driver);
                dlg.open();
                DriverContainerGroup.this.tableViewer.refresh();
                DriverContainerGroup.this.selectFirst();
            }
        };
        this.changeDriver = new Action(){
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getEditDriver());

            public String getToolTipText() {
                return Messages.getString("Change_the_selected_Driver_8");
            }

            public String getText() {
                return Messages.getString("Change_the_selected_Driver_8");
            }

            public ImageDescriptor getHoverImageDescriptor() {
                return this.img;
            }

            public ImageDescriptor getImageDescriptor() {
                return this.img;
            }

            public void run() {
                StructuredSelection sel = (StructuredSelection)DriverContainerGroup.this.tableViewer.getSelection();
                ISQLDriver dv = (ISQLDriver)sel.getFirstElement();
                if (dv != null) {
                    CreateDriverDlg dlg = new CreateDriverDlg(DriverContainerGroup.this.getShell(), DriverContainerGroup.this.driverModel, 2, dv);
                    dlg.open();
                    DriverContainerGroup.this.tableViewer.refresh();
                    DriverContainerGroup.this.selectFirst();
                }
            }
        };
        this.copyDriver = new Action(){
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getCopyDriver());

            public String getToolTipText() {
                return Messages.getString("Copy_the_selected_Driver_10");
            }

            public String getText() {
                return Messages.getString("Copy_the_selected_Driver_10");
            }

            public ImageDescriptor getHoverImageDescriptor() {
                return this.img;
            }

            public ImageDescriptor getImageDescriptor() {
                return this.img;
            }

            public void run() {
                StructuredSelection sel = (StructuredSelection)DriverContainerGroup.this.tableViewer.getSelection();
                ISQLDriver dv = (ISQLDriver)sel.getFirstElement();
                if (dv != null) {
                    CreateDriverDlg dlg = new CreateDriverDlg(DriverContainerGroup.this.getShell(), DriverContainerGroup.this.driverModel, 3, dv);
                    dlg.open();
                    DriverContainerGroup.this.tableViewer.refresh();
                }
            }
        };
        this.deleteDriver = new Action(){
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getDeleteDriver());

            public String getToolTipText() {
                return Messages.getString("Delete_the_selected_Driver_12");
            }

            public ImageDescriptor getHoverImageDescriptor() {
                return this.img;
            }

            public ImageDescriptor getImageDescriptor() {
                return this.img;
            }

            public void run() {
                StructuredSelection sel = (StructuredSelection)DriverContainerGroup.this.tableViewer.getSelection();
                ISQLDriver dv = (ISQLDriver)sel.getFirstElement();
                if (dv != null) {
                    DriverContainerGroup.this.driverModel.removeDriver(dv);
                    DriverContainerGroup.this.tableViewer.refresh();
                    DriverContainerGroup.this.selectFirst();
                }
            }
        };
    }

    public DriverContainerGroup(Composite parent, DriverModel dm) {
        super(parent, 0);
        this.driverModel = dm;
        this.setLayout((Layout)new FillLayout());
        Composite myParent = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        myParent.setLayout((Layout)layout);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        this.createActions();
        toolBarMgr.add((IAction)this.newDriver);
        toolBarMgr.add((IAction)this.changeDriver);
        toolBarMgr.add((IAction)this.copyDriver);
        toolBarMgr.add((IAction)this.deleteDriver);
        toolBarMgr.createControl(myParent);
        GridData gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        toolBarMgr.getControl().setLayoutData((Object)gid);
        gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        this.tableViewer = new TableViewer(myParent, 772);
        this.tableViewer.getControl().setLayoutData((Object)gid);
        this.tableViewer.setContentProvider((IContentProvider)new DriverContentProvider());
        final DriverLabelProvider dlp = new DriverLabelProvider();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)dlp);
        this.tableViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dlp.dispose();
            }
        });
        this.tableViewer.setInput((Object)this.driverModel);
        this.selectFirst();
        Table table = this.tableViewer.getTable();
        MenuManager menuMgr = new MenuManager("#DriverMenu");
        menuMgr.setRemoveAllWhenShown(false);
        menuMgr.add((IAction)this.newDriver);
        menuMgr.add((IAction)this.changeDriver);
        menuMgr.add((IAction)this.copyDriver);
        Menu driverContextMenu = menuMgr.createContextMenu((Control)table);
        this.tableViewer.getTable().setMenu(driverContextMenu);
        myParent.layout();
        parent.layout();
    }

    void selectFirst() {
        if (this.driverModel.getElements().length > 0) {
            Object obj = this.driverModel.getElements()[0];
            StructuredSelection sel = new StructuredSelection(obj);
            this.tableViewer.setSelection((ISelection)sel);
        }
    }
}

