/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dialogs;

import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordConnDlg
extends TitleAreaDialog {
    ISQLAlias alias;
    private Button okButton;
    private Button cancelButton;
    private ISQLDriver driver;
    private DriverModel driverModel;
    private Text userTxt;
    private Text pswdTxt;
    Button fAutoCommitBox;
    Button fCommitOnCloseBox;
    String user;
    String passwd;
    private boolean autoCommit = false;
    private boolean commitOnClose = false;
    IPreferenceStore store;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public PasswordConnDlg(Shell parentShell, ISQLAlias al, DriverModel dm, IPreferenceStore store) {
        super(parentShell);
        this.alias = al;
        this.driverModel = dm;
        this.store = store;
        IIdentifier id = this.alias.getDriverIdentifier();
        this.driver = this.driverModel.getDriver(id);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("Connection_1"));
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(Messages.getString("Connection_4"));
        this.setMessage(Messages.getString("Insert_Password_1"));
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        String salias;
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Composite nameGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        nameGroup.setLayoutData((Object)data);
        Label label = new Label(nameGroup, 64);
        label.setText(Messages.getString("Alias_1"));
        Label aliasTxt = new Label(nameGroup, 64);
        aliasTxt.setText(this.alias.getName());
        Label label2 = new Label(nameGroup, 64);
        label2.setText(Messages.getString("Driver_2"));
        Label driverTxt = new Label(nameGroup, 64);
        driverTxt.setText(this.driver.getName());
        Label label3 = new Label(nameGroup, 64);
        label3.setText(Messages.getString("Url_3"));
        Label urlTxt = new Label(nameGroup, 64);
        urlTxt.setText(this.alias.getUrl());
        Label label4 = new Label(nameGroup, 64);
        label4.setText(Messages.getString("User_4"));
        this.userTxt = new Text(nameGroup, 2048);
        String name = salias = this.alias.getUserName();
        String password = this.alias.getPassword();
        this.userTxt.setText(name);
        data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 1;
        this.userTxt.setLayoutData((Object)data);
        Label label5 = new Label(nameGroup, 64);
        label5.setText(Messages.getString("Password_5"));
        this.pswdTxt = new Text(nameGroup, 2048);
        this.pswdTxt.setText(password);
        this.pswdTxt.setEchoChar('*');
        data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 1;
        this.pswdTxt.setLayoutData((Object)data);
        this.pswdTxt.setFocus();
        this.fAutoCommitBox = new Button(nameGroup, 32);
        this.fAutoCommitBox.setText(Messages.getString("PasswordConnDlg.AutoCommit_1"));
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 1;
        this.fAutoCommitBox.setLayoutData((Object)gd);
        this.fCommitOnCloseBox = new Button(nameGroup, 32);
        this.fCommitOnCloseBox.setText(Messages.getString("PasswordConnDlg.Commit_On_Close_2"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fCommitOnCloseBox.setLayoutData((Object)gd);
        this.fAutoCommitBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (PasswordConnDlg.this.fAutoCommitBox.getSelection()) {
                    PasswordConnDlg.this.fCommitOnCloseBox.setEnabled(false);
                } else {
                    PasswordConnDlg.this.fCommitOnCloseBox.setEnabled(true);
                }
            }
        });
        this.fAutoCommitBox.getDisplay().asyncExec(new Runnable(){

            public void run() {
                PasswordConnDlg.this.fCommitOnCloseBox.setSelection(PasswordConnDlg.this.store.getBoolean("commitonclose"));
                PasswordConnDlg.this.fAutoCommitBox.setSelection(PasswordConnDlg.this.store.getBoolean("autocommit"));
                if (PasswordConnDlg.this.fAutoCommitBox.getSelection()) {
                    PasswordConnDlg.this.fCommitOnCloseBox.setEnabled(false);
                } else {
                    PasswordConnDlg.this.fCommitOnCloseBox.setEnabled(true);
                }
            }
        });
        return parentComposite;
    }

    public String getPassword() {
        return this.passwd;
    }

    protected void okPressed() {
        this.passwd = this.pswdTxt.getText();
        this.user = this.userTxt.getText();
        this.autoCommit = this.fAutoCommitBox.getSelection();
        this.commitOnClose = this.fCommitOnCloseBox.getSelection();
        super.okPressed();
    }

    public String getUser() {
        return this.user;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public boolean getCommitOnClose() {
        return this.commitOnClose;
    }
}

