/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.sqlexplorer.PluginLoader;
import net.sourceforge.sqlexplorer.URLUtil;
import net.sourceforge.sqlexplorer.dbviewer.model.CatalogNode;
import net.sourceforge.sqlexplorer.dbviewer.model.DatabaseNode;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.SchemaNode;
import net.sourceforge.sqlexplorer.ext.EditorPluginInfo;
import net.sourceforge.sqlexplorer.ext.IActivablePanel;
import net.sourceforge.sqlexplorer.ext.IPlugin;
import net.sourceforge.sqlexplorer.ext.PluginInfo;
import net.sourceforge.sqlexplorer.ext.SessionPluginInfo;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.TreeViewer;

public class PluginManager {
    private List _plugins = new ArrayList();
    private Map _loadedPlugins = new HashMap();
    private List _sessionPlugins = new ArrayList();
    private List _editorPlugins = new ArrayList();
    private Map _activeSessions = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public synchronized void sessionStarted(SessionTreeNode sessionNode) {
        if (sessionNode == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        ArrayList<SessionPluginInfo> plugins = new ArrayList<SessionPluginInfo>();
        this._activeSessions.put(sessionNode.getIdentifier(), plugins);
        Iterator it = this._sessionPlugins.iterator();
        while (it.hasNext()) {
            SessionPluginInfo spi = (SessionPluginInfo)it.next();
            try {
                if (!spi.getSessionPlugin().sessionStarted(sessionNode)) continue;
                plugins.add(spi);
            }
            catch (Throwable th) {
                String msg = "Error occured in IPlugin.sessionStarted() for " + spi.getPlugin().getDescriptiveName();
                SQLExplorerPlugin.error(msg, th);
            }
        }
    }

    public synchronized void sessionEnding(SessionTreeNode sessionNode) {
        if (sessionNode == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        List plugins = (List)this._activeSessions.remove(sessionNode.getIdentifier());
        if (plugins != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                SessionPluginInfo spi = (SessionPluginInfo)it.next();
                try {
                    spi.getSessionPlugin().sessionEnding(sessionNode);
                }
                catch (Throwable th) {
                    String msg = "Error occured in IPlugin.sessionEnding() for " + spi.getPlugin().getDescriptiveName();
                    SQLExplorerPlugin.error(msg, th);
                }
            }
        }
    }

    public synchronized void unloadPlugins() {
        Iterator it = this._loadedPlugins.values().iterator();
        while (it.hasNext()) {
            IPlugin plugin = (IPlugin)it.next();
            try {
                plugin.unload();
            }
            catch (Throwable th) {
                String msg = "Error ocured unloading plugin: " + plugin.getInternalName();
                SQLExplorerPlugin.error(msg, th);
            }
        }
    }

    public synchronized PluginInfo[] getPluginInformation() {
        return this._plugins.toArray(new PluginInfo[this._plugins.size()]);
    }

    public IDbModel[] getSchemaAddedTypes(SchemaNode schemaNode, SessionTreeNode sessionNode) {
        ArrayList<IDbModel> objTypesList = new ArrayList<IDbModel>();
        List plugins = (List)this._activeSessions.get(sessionNode.getIdentifier());
        if (plugins != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                SessionPluginInfo spi = (SessionPluginInfo)it.next();
                IDbModel[] objTypes = spi.getSessionPlugin().getSchemaAddedTypes(schemaNode, sessionNode);
                if (objTypes == null) continue;
                int i = 0;
                while (i < objTypes.length) {
                    objTypesList.add(objTypes[i]);
                    ++i;
                }
            }
        }
        return objTypesList.toArray(new IDbModel[0]);
    }

    public IDbModel[] getCatalogAddedTypes(CatalogNode catalogNode, SessionTreeNode sessionNode) {
        ArrayList<IDbModel> objTypesList = new ArrayList<IDbModel>();
        List plugins = (List)this._activeSessions.get(sessionNode.getIdentifier());
        if (plugins != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                SessionPluginInfo spi = (SessionPluginInfo)it.next();
                IDbModel[] objTypes = spi.getSessionPlugin().getCatalogAddedTypes(catalogNode, sessionNode);
                if (objTypes == null) continue;
                int i = 0;
                while (i < objTypes.length) {
                    objTypesList.add(objTypes[i]);
                    ++i;
                }
            }
        }
        return objTypesList.toArray(new IDbModel[0]);
    }

    public IDbModel[] getDbRootAddedTypes(DatabaseNode root, SessionTreeNode sessionNode) {
        ArrayList<IDbModel> objTypesList = new ArrayList<IDbModel>();
        List plugins = (List)this._activeSessions.get(sessionNode.getIdentifier());
        if (plugins != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                SessionPluginInfo spi = (SessionPluginInfo)it.next();
                IDbModel[] objTypes = spi.getSessionPlugin().getDbRootAddedTypes(root, sessionNode);
                if (objTypes == null) continue;
                int i = 0;
                while (i < objTypes.length) {
                    objTypesList.add(objTypes[i]);
                    ++i;
                }
            }
        }
        return objTypesList.toArray(new IDbModel[0]);
    }

    public void loadPlugins() {
        ArrayList<URL> pluginUrls = new ArrayList<URL>();
        File dir = null;
        URL file1 = URLUtil.getPluggableFile("plugins" + File.separator);
        try {
            dir = new File(PluginManager.asLocalString(file1));
        }
        catch (Throwable throwable) {}
        if (dir == null) {
            return;
        }
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                String fileName;
                File file = files[i];
                if (file.isFile() && ((fileName = file.getAbsolutePath()).toLowerCase().endsWith(".zip") || fileName.toLowerCase().endsWith(".jar"))) {
                    try {
                        URL url = URLUtil.getResourceURL("plugins/" + file.getName());
                        url = file.toURL();
                        pluginUrls.add(url);
                    }
                    catch (IOException ex) {
                        String msg = "Unable to load plugin jar: " + fileName;
                        SQLExplorerPlugin.error(msg, ex);
                    }
                }
                ++i;
            }
        }
        URL[] urls = pluginUrls.toArray(new URL[pluginUrls.size()]);
        PluginLoader tl = new PluginLoader(urls);
        try {
            Class[] classes = tl.getPluginClasses();
            int i = 0;
            while (i < classes.length) {
                Class clazz = classes[i];
                try {
                    this.loadPlugin(clazz);
                }
                catch (Throwable th) {
                    String msg = "Error occured loading plugin class: " + clazz.getName();
                    SQLExplorerPlugin.error(msg, th);
                }
                ++i;
            }
        }
        catch (IOException ex) {
            String msg = "Error occured retrieving plugins. No plugins have been loaded.";
            SQLExplorerPlugin.error(msg, ex);
        }
    }

    public void initializePlugins() {
        Iterator it = this._loadedPlugins.values().iterator();
        while (it.hasNext()) {
            IPlugin plugin = (IPlugin)it.next();
            try {
                plugin.initialize();
            }
            catch (Throwable th) {
                String msg = "Error occured initializing plugin: " + plugin.getInternalName();
                SQLExplorerPlugin.error(msg, th);
            }
        }
    }

    private void loadPlugin(Class pluginClass) {
        block10: {
            PluginInfo pi = new PluginInfo(pluginClass.getName());
            try {
                Class<?> clazz;
                IPlugin plugin = (IPlugin)pluginClass.newInstance();
                pi.setPlugin(plugin);
                this._plugins.add(pi);
                if (!this.validatePlugin(plugin)) break block10;
                plugin.load();
                pi.setLoaded(true);
                this._loadedPlugins.put(plugin.getInternalName(), plugin);
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("net.sourceforge.sqlexplorer.ext.ISessionPlugin");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.isAssignableFrom(pluginClass)) {
                    this._sessionPlugins.add(new SessionPluginInfo(pi));
                }
                if ((clazz = class$1) == null) {
                    try {
                        clazz = class$1 = Class.forName("net.sourceforge.sqlexplorer.ext.IEditorPlugin");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(pluginClass)) {
                    this._editorPlugins.add(new EditorPluginInfo(pi));
                }
            }
            catch (Throwable th) {
                String msg = "Error occured loading class " + pluginClass.getName() + " from plugin";
                SQLExplorerPlugin.error(msg, th);
            }
        }
    }

    private boolean validatePlugin(IPlugin plugin) {
        String pluginInternalName = plugin.getInternalName();
        if (pluginInternalName == null || pluginInternalName.trim().length() == 0) {
            SQLExplorerPlugin.error("Plugin " + plugin.getClass().getName() + "doesn't return a valid getInternalName()", new Exception());
            return false;
        }
        if (this._loadedPlugins.get(pluginInternalName) != null) {
            SQLExplorerPlugin.error("A Plugin with the internal name " + pluginInternalName + " has already been loaded", new Exception());
            return false;
        }
        return true;
    }

    public static String asLocalString(URL url) throws IOException {
        return PluginManager.asLocalURL(url).getFile();
    }

    public static URL asLocalURL(URL url) throws IOException {
        return Platform.resolve((URL)url);
    }

    public Map getImageDescriptorsMap() {
        HashMap map = new HashMap();
        Iterator it = this._loadedPlugins.values().iterator();
        while (it.hasNext()) {
            IPlugin plugin = (IPlugin)it.next();
            try {
                Map mp = plugin.getIconMap();
                if (mp == null) continue;
                map.putAll(mp);
            }
            catch (Exception e) {
                String msg = "Error ocurred calling getImageDescriptorsMap: " + plugin.getInternalName();
                SQLExplorerPlugin.error(msg, e);
            }
        }
        return map;
    }

    public IAction[] getTypeActions(SessionTreeNode sessionNode, IDbModel node, TreeViewer tv) {
        List plugins = (List)this._activeSessions.get(sessionNode.getIdentifier());
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        if (plugins != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                SessionPluginInfo spi = (SessionPluginInfo)it.next();
                IAction[] objActions = spi.getSessionPlugin().getTypeActionsAdded(sessionNode, node, tv);
                if (objActions == null) continue;
                int i = 0;
                while (i < objActions.length) {
                    actionList.add(objActions[i]);
                    ++i;
                }
            }
            return actionList.toArray(new IAction[0]);
        }
        return null;
    }

    public IAction[] getAddedActions(SessionTreeNode sessionNode, IDbModel node, TreeViewer tv) {
        List plugins = (List)this._activeSessions.get(sessionNode.getIdentifier());
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        if (plugins != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                SessionPluginInfo spi = (SessionPluginInfo)it.next();
                IAction[] objActions = spi.getSessionPlugin().getAddedActions(sessionNode, node, tv);
                if (objActions == null) continue;
                int i = 0;
                while (i < objActions.length) {
                    actionList.add(objActions[i]);
                    ++i;
                }
            }
            return actionList.toArray(new IAction[0]);
        }
        return null;
    }

    public IContributionItem[] getEditorContextMenuActions(SQLEditor editor) {
        List plugins = this._editorPlugins;
        ArrayList<IContributionItem> actionList = new ArrayList<IContributionItem>();
        if (plugins != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                EditorPluginInfo spi = (EditorPluginInfo)it.next();
                IContributionItem[] objActions = spi.getEditorPlugin().getContextMenuActions(editor);
                if (objActions == null) continue;
                int i = 0;
                while (i < objActions.length) {
                    actionList.add(objActions[i]);
                    ++i;
                }
            }
            return actionList.toArray(new IContributionItem[0]);
        }
        return null;
    }

    public IAction[] getEditorToolbarActions(SQLEditor editor) {
        List plugins = this._editorPlugins;
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        if (plugins != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                EditorPluginInfo spi = (EditorPluginInfo)it.next();
                IAction[] objActions = spi.getEditorPlugin().getEditorToolbarActions(editor);
                if (objActions == null) continue;
                int i = 0;
                while (i < objActions.length) {
                    actionList.add(objActions[i]);
                    ++i;
                }
            }
            return actionList.toArray(new IAction[0]);
        }
        return null;
    }

    public IActivablePanel[] getAddedPanels(SessionTreeNode sessionNode, IDbModel node) {
        List plugins = (List)this._activeSessions.get(sessionNode.getIdentifier());
        ArrayList<IActivablePanel> panelsList = new ArrayList<IActivablePanel>();
        if (plugins != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                SessionPluginInfo spi = (SessionPluginInfo)it.next();
                IActivablePanel[] panels = spi.getSessionPlugin().getAddedPanels(sessionNode, node);
                if (panels == null) continue;
                int i = 0;
                while (i < panels.length) {
                    panelsList.add(panels[i]);
                    ++i;
                }
            }
            return panelsList.toArray(new IActivablePanel[0]);
        }
        return new IActivablePanel[0];
    }
}

