/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sourceforge.sqlexplorer.gef.editors.TableComponentEditPolicy;
import net.sourceforge.sqlexplorer.gef.figures.NoteFigure;
import net.sourceforge.sqlexplorer.gef.model.Note;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;

public class NotePart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    protected void refreshVisuals() {
        ((NoteFigure)this.getFigure()).setText(((Note)this.getModel()).getText());
        Point loc = this.getNote().getLocation();
        Dimension size = this.getNote().getSize();
        if (size == null) {
            size = new Dimension(20, 20);
        }
        if (loc == null) {
            loc = new Point(10, 10);
        }
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }

    protected IFigure createFigure() {
        NoteFigure noteFigure = new NoteFigure(this.getNote());
        return noteFigure;
    }

    public Note getNote() {
        return (Note)this.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TableComponentEditPolicy());
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        ((Note)this.getModel()).addPropertyChangeListener(this);
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        ((Note)this.getModel()).removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertychangeevent) {
        this.refresh();
    }

    public void exec() {
        CommandStack commandstack = this.getRoot().getViewer().getEditDomain().getCommandStack();
        Command command = this.getCommand((Request)new DirectEditRequest());
        if (command != null && command.canExecute()) {
            commandstack.execute(command);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            this.exec();
            return;
        }
        super.performRequest(request);
    }
}

