/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.editors;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.gef.editors.SchemaEditor;
import net.sourceforge.sqlexplorer.gef.model.Note;
import net.sourceforge.sqlexplorer.gef.model.Schema;
import net.sourceforge.sqlexplorer.gef.wizards.ReverseDatabaseWizard;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class SchemaEditorContextMenuProvider
extends ContextMenuProvider {
    ActionRegistry actionregistry;
    SchemaEditor editorPart;

    public SchemaEditorContextMenuProvider(EditPartViewer viewer, ActionRegistry actionregistry, SchemaEditor editorPart) {
        super(viewer);
        this.actionregistry = actionregistry;
        this.editorPart = editorPart;
    }

    public void buildContextMenu(IMenuManager imenumanager) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)imenumanager);
        Object action = this.actionregistry.getAction((Object)ActionFactory.UNDO.getId());
        imenumanager.appendToGroup("org.eclipse.gef.group.undo", action);
        action = this.actionregistry.getAction((Object)ActionFactory.REDO.getId());
        imenumanager.appendToGroup("org.eclipse.gef.group.undo", action);
        action = this.actionregistry.getAction((Object)ActionFactory.PASTE.getId());
        if (action != null && action.isEnabled()) {
            imenumanager.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        if ((action = this.actionregistry.getAction((Object)ActionFactory.DELETE.getId())) != null && action.isEnabled()) {
            imenumanager.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        if ((action = this.actionregistry.getAction((Object)"org.eclipse.gef.direct_edit")) != null && action.isEnabled()) {
            imenumanager.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        action = this.actionregistry.getAction((Object)"org.eclipse.gef.align_left");
        MenuManager submenu = new MenuManager(Messages.getString("SchemaEditorContextMenuProvider.Align..._1"));
        if (action != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.actionregistry.getAction((Object)"org.eclipse.gef.align_center")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.actionregistry.getAction((Object)"org.eclipse.gef.align_right")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.actionregistry.getAction((Object)"org.eclipse.gef.align_top")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.actionregistry.getAction((Object)"org.eclipse.gef.align_middle")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.actionregistry.getAction((Object)"org.eclipse.gef.align_bottom")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if (!submenu.isEmpty()) {
            imenumanager.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)submenu);
        }
        action = this.actionregistry.getAction((Object)ActionFactory.SAVE.getId());
        imenumanager.appendToGroup("org.eclipse.gef.group.save", action);
        action = this.actionregistry.getAction((Object)ActionFactory.PRINT.getId());
        if (action != null) {
            imenumanager.appendToGroup("org.eclipse.gef.group.print", action);
        }
        action = new SelectionAction((IWorkbenchPart)this.editorPart){

            protected boolean calculateEnabled() {
                return true;
            }

            public void run() {
                ReverseDatabaseWizard reverseDatabaseWizard = new ReverseDatabaseWizard(SchemaEditorContextMenuProvider.this.editorPart.getSchema());
                reverseDatabaseWizard.init(SchemaEditorContextMenuProvider.this.editorPart.getSite().getWorkbenchWindow().getWorkbench(), (IStructuredSelection)this.getSelection());
                WizardDialog resizableWizardDialog = new WizardDialog(this, SchemaEditorContextMenuProvider.this.editorPart.getSite().getShell(), (IWizard)reverseDatabaseWizard){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected int getShellStyle() {
                        return super.getShellStyle() | 0x10;
                    }
                };
                resizableWizardDialog.open();
                Command command = reverseDatabaseWizard.getCommand();
                this.execute(command);
            }

            public String getText() {
                return Messages.getString("SchemaEditorContextMenuProvider.Reverse_Database_2");
            }
        };
        imenumanager.add(action);
        final Schema sc = this.editorPart.getSchema();
        action = new SelectionAction((IWorkbenchPart)this.editorPart){

            protected boolean calculateEnabled() {
                return true;
            }

            public void run() {
                Command command = new Command(this, sc){
                    Note nt;
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ Schema val$sc;
                    {
                        this.this$1 = var1_1;
                        this.val$sc = schema;
                        this.nt = null;
                    }

                    public void redo() {
                        this.execute();
                    }

                    public void execute() {
                        this.nt = new Note();
                        this.nt.setLocation(new Point(10, 20));
                        this.nt.setSize(new Dimension(80, 40));
                        this.nt.setParent(this.val$sc);
                        this.val$sc.addChild(this.nt);
                    }

                    public void undo() {
                        this.val$sc.removeChild(this.nt);
                    }
                };
                this.execute(command);
            }

            public String getText() {
                return Messages.getString("SchemaEditorContextMenuProvider.Add_Note_3");
            }
        };
        imenumanager.add(action);
        action = new SelectionAction((IWorkbenchPart)this.editorPart){

            public String getText() {
                return Messages.getString("SchemaEditorContextMenuProvider.Export..._4");
            }

            protected boolean calculateEnabled() {
                return true;
            }

            public void run() {
                FileDialog fd = new FileDialog(SchemaEditorContextMenuProvider.this.editorPart.getGraphicalViewer().getControl().getShell(), 8192);
                fd.setFilterExtensions(new String[]{"*.jpg", "*.bmp"});
                String path = fd.open();
                if (path == null) {
                    return;
                }
                if (!path.endsWith(".bmp") && !path.endsWith(".jpg")) {
                    path = String.valueOf(path) + ".jpg";
                }
                try {
                    GraphicalViewer gv = SchemaEditorContextMenuProvider.this.editorPart.getGraphicalViewer();
                    LayerManager lm = (LayerManager)gv.getEditPartRegistry().get(LayerManager.ID);
                    IFigure f = lm.getLayer((Object)"Printable Layers");
                    Dimension sz = f.getSize();
                    Image image = new Image((Device)gv.getControl().getDisplay(), sz.width, sz.height);
                    GC gc = new GC((Drawable)image);
                    SWTGraphics graphics = new SWTGraphics(gc);
                    f.paint((Graphics)graphics);
                    graphics.dispose();
                    gc.dispose();
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.logicalScreenWidth = sz.width;
                    imageLoader.logicalScreenHeight = sz.height;
                    imageLoader.data = new ImageData[]{image.getImageData()};
                    if (path.endsWith(".bmp")) {
                        imageLoader.save(path, 0);
                    } else if (path.endsWith(".jpg")) {
                        imageLoader.save(path, 4);
                    }
                    image.dispose();
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error("Error saving bitmap file", e);
                }
            }
        };
        imenumanager.add(action);
    }
}

