/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import net.sourceforge.sqlexplorer.gef.editors.TableComponentEditPolicy;
import net.sourceforge.sqlexplorer.gef.editors.TableDirectEditPolicy;
import net.sourceforge.sqlexplorer.gef.figures.TableFigure;
import net.sourceforge.sqlexplorer.gef.model.Table;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;

public class TableEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    protected List getModelSourceConnections() {
        return this.getTable().getSourceConnections();
    }

    protected List getModelTargetConnections() {
        return this.getTable().getTargetConnections();
    }

    protected ConnectionEditPart createConnection(Object obj) {
        return super.createConnection(obj);
    }

    public Table getTable() {
        return (Table)this.getModel();
    }

    protected void refreshVisuals() {
        Table tb = (Table)this.getModel();
        TableFigure fig = (TableFigure)this.getFigure();
        if (tb.isShowQualifiedName()) {
            fig.setLabel(tb.getQualifiedName());
        } else {
            fig.setLabel(tb.getSimpleName());
        }
        fig.setColumnTypeVisible(tb.isShowColumnDetail());
        Point loc = this.getTable().getLocation();
        Dimension size = this.getTable().getSize();
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        super.refreshSourceConnections();
        super.refreshTargetConnections();
    }

    protected IFigure createFigure() {
        TableFigure tableFigure = new TableFigure(this.getTable());
        return tableFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TableComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new TableDirectEditPolicy());
    }

    protected final String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return ((TableFigure)this.getFigure()).getConnectionAnchorName(c);
    }

    public void exec() {
        CommandStack commandstack = this.getRoot().getViewer().getEditDomain().getCommandStack();
        Command command = this.getCommand((Request)new DirectEditRequest());
        if (command != null && command.canExecute()) {
            commandstack.execute(command);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            this.exec();
            return;
        }
        super.performRequest(request);
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        ((Table)this.getModel()).addPropertyChangeListener(this);
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        ((Table)this.getModel()).removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertychangeevent) {
        this.refresh();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        ChopboxAnchor chopboxanchor = new ChopboxAnchor((IFigure)((TableFigure)this.getFigure()));
        return chopboxanchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)((TableFigure)this.getFigure()));
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)((TableFigure)this.getFigure()));
    }
}

