/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.editors;

import net.sourceforge.sqlexplorer.gef.commands.CreateBendpointCommand;
import net.sourceforge.sqlexplorer.gef.commands.DeleteBendpointCommand;
import net.sourceforge.sqlexplorer.gef.commands.MoveBendpointCommand;
import net.sourceforge.sqlexplorer.gef.model.Link;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;

class WireBendpointEditPolicy
extends BendpointEditPolicy {
    WireBendpointEditPolicy() {
    }

    protected Command getCreateBendpointCommand(BendpointRequest request) {
        CreateBendpointCommand com = new CreateBendpointCommand();
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        com.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ref1);
        conn.translateToRelative((Translatable)ref2);
        com.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
        com.setLink((Link)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        MoveBendpointCommand com = new MoveBendpointCommand();
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        com.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ref1);
        conn.translateToRelative((Translatable)ref2);
        com.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
        com.setLink((Link)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        DeleteBendpointCommand com = new DeleteBendpointCommand();
        Point p = request.getLocation();
        com.setLocation(p);
        com.setLink((Link)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }
}

