/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.model;

import java.io.Serializable;
import net.sourceforge.sqlexplorer.gef.model.DimensionPropertySource;
import net.sourceforge.sqlexplorer.gef.model.LocationPropertySource;
import net.sourceforge.sqlexplorer.gef.model.Table;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class TablePropertyManager
implements Serializable {
    Table tb;
    protected static IPropertyDescriptor[] descriptors = null;
    public static String ID_SIZE = "size_property";
    public static String ID_LOCATION = "location_property";
    public static String ID_LABEL = "label_property";
    public static String ID_SHOW_DETAILS = "columns_property";
    public static String ID_SHOW_QUALIFIED = "title_property";
    public static String ID_SCHEMA = "schema_property";
    public static String ID_CATALOG = "catalog_property";

    static {
        ComboBoxPropertyDescriptor iProp = new ComboBoxPropertyDescriptor((Object)ID_SHOW_QUALIFIED, "Show Qualified Name", new String[]{"false", "true"});
        ComboBoxPropertyDescriptor iProp2 = new ComboBoxPropertyDescriptor((Object)ID_SHOW_DETAILS, "Show Column Types", new String[]{"false", "true"});
        descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)ID_LABEL, "Table Name"), new PropertyDescriptor((Object)ID_SCHEMA, "Schema"), new PropertyDescriptor((Object)ID_CATALOG, "Catalog"), new PropertyDescriptor((Object)ID_SIZE, "Size"), new PropertyDescriptor((Object)ID_LOCATION, "Location"), iProp2, iProp};
        iProp.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object obj) {
                if (obj instanceof Integer) {
                    if ((Integer)obj == 1) {
                        return "true";
                    }
                    return "false";
                }
                return "";
            }
        });
        iProp2.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object obj) {
                if (obj instanceof Integer) {
                    if ((Integer)obj == 1) {
                        return "true";
                    }
                    return "false";
                }
                return "";
            }
        });
    }

    TablePropertyManager(Table tb) {
        this.tb = tb;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object propName) {
        if (ID_SIZE.equals(propName)) {
            return new DimensionPropertySource(this.tb.getSize());
        }
        if (ID_LOCATION.equals(propName)) {
            return new LocationPropertySource(this.tb.getLocation());
        }
        if (ID_LABEL.equals(propName)) {
            return this.tb.getQualifiedName();
        }
        if (ID_SCHEMA.equals(propName)) {
            return this.tb.getSchemaName();
        }
        if (ID_CATALOG.equals(propName)) {
            return this.tb.getCatalogName();
        }
        if (ID_SHOW_DETAILS.equals(propName)) {
            if (this.tb.isShowColumnDetail()) {
                return new Integer(1);
            }
            return new Integer(0);
        }
        if (ID_SHOW_QUALIFIED.equals(propName)) {
            if (this.tb.isShowQualifiedName()) {
                return new Integer(1);
            }
            return new Integer(0);
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        if (ID_SIZE.equals(id)) {
            DimensionPropertySource dimPS = (DimensionPropertySource)value;
            this.tb.setSize(new Dimension(dimPS.getValue()));
        } else if (ID_LOCATION.equals(id)) {
            LocationPropertySource locPS = (LocationPropertySource)value;
            this.tb.setLocation(new Point(locPS.getValue()));
        } else if (ID_SHOW_DETAILS.equals(id)) {
            if (value instanceof Integer) {
                if ((Integer)value == 1) {
                    this.tb.setShowColumnDetail(true);
                } else {
                    this.tb.setShowColumnDetail(false);
                }
            }
        } else if (ID_SHOW_QUALIFIED.equals(id) && value instanceof Integer) {
            if ((Integer)value == 1) {
                this.tb.setShowQualifiedName(true);
            } else {
                this.tb.setShowQualifiedName(false);
            }
        }
    }
}

