/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.gef.commands.AddTablesToSchemaCommand;
import net.sourceforge.sqlexplorer.gef.model.Schema;
import net.sourceforge.sqlexplorer.gef.wizards.SelectConnection;
import net.sourceforge.sqlexplorer.gef.wizards.SelectSchemaCatalog;
import net.sourceforge.sqlexplorer.gef.wizards.SelectTables;
import net.sourceforge.sqlexplorer.gef.wizards.TableAdapter;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class ReverseDatabaseWizard
extends Wizard
implements IWorkbenchWizard {
    Schema schema;
    SessionTreeNode session;
    List selectedSchemas;
    IWorkbench workbench;
    IStructuredSelection selection;
    SelectConnection selConnectionPage = null;
    SelectSchemaCatalog selSchemaCatalogPage = null;
    SelectTables selTables = null;
    Command command;

    public ReverseDatabaseWizard(Schema schema) {
        this.schema = schema;
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            ReverseDatabaseWizard.this.runFinish(monitor);
                        }
                        catch (Exception exception) {
                            throw new InvocationTargetException(exception);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    monitor.done();
                }
            });
        }
        catch (Throwable throwable) {}
        return true;
    }

    protected void runFinish(IProgressMonitor monitor) throws Exception {
        int tableCount = this.selTables.selectedList.size();
        monitor.beginTask("Reading meta-data... ", tableCount);
        ArrayList<TableAdapter> tableAdapterList = new ArrayList<TableAdapter>();
        int i = 0;
        while (i < tableCount) {
            if (monitor.isCanceled()) {
                throw new InterruptedException("Operation was cancelled by user");
            }
            TableNode tn = (TableNode)this.selTables.selectedList.get(i);
            monitor.subTask(tn.getTableInfo().getQualifiedName());
            TableAdapter tadapt = new TableAdapter(tn);
            tableAdapterList.add(tadapt);
            monitor.worked(1);
            ++i;
        }
        this.command = new AddTablesToSchemaCommand(this.schema, tableAdapterList);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.selConnectionPage = new SelectConnection("Select Connection", this);
        this.addPage((IWizardPage)this.selConnectionPage);
        this.selSchemaCatalogPage = new SelectSchemaCatalog("Select Schemas or Catalogs", this);
        this.addPage((IWizardPage)this.selSchemaCatalogPage);
        this.selTables = new SelectTables("Select tables", this);
        this.addPage((IWizardPage)this.selTables);
    }

    public void setConnection(SessionTreeNode session) {
        this.session = session;
        this.selSchemaCatalogPage.updateSessionNode(session);
    }

    public SessionTreeNode getSessionTreeNode() {
        return this.session;
    }

    public void setSelectedSchemas(List list) {
        this.selTables.updateSelectedSchemas(list);
        this.selectedSchemas = list;
    }

    public List getSelectedSchemas() {
        return this.selectedSchemas;
    }

    public Command getCommand() {
        return this.command;
    }
}

