/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.gef.wizards.ReverseDatabaseWizard;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectSchemaCatalog
extends WizardPage {
    ReverseDatabaseWizard wizard;
    ListViewer lvLeft;
    ListViewer lvRight;
    ArrayList selectedList = new ArrayList();

    protected SelectSchemaCatalog(String pageName, ReverseDatabaseWizard wizard) {
        super(pageName);
        this.setTitle(pageName);
        this.wizard = wizard;
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite1 = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite1.setLayout((Layout)layout);
        Label label = new Label(composite1, 0);
        label.setText("Database schemas or catalogs");
        new Label(composite1, 0);
        Label label1 = new Label(composite1, 0);
        label1.setText("Schemas or catalogs selected for import");
        org.eclipse.swt.widgets.List ls = new org.eclipse.swt.widgets.List(composite1, 2818);
        ls.setLayoutData((Object)new GridData(1808));
        this.lvLeft = new ListViewer(ls);
        this.lvLeft.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] objs = ((List)inputElement).toArray();
                return objs;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.lvLeft.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Composite cmp2 = new Composite(composite1, 0);
        cmp2.setLayout((Layout)new GridLayout(1, true));
        final org.eclipse.swt.widgets.List ls2 = new org.eclipse.swt.widgets.List(composite1, 2818);
        ls2.setLayoutData((Object)new GridData(1808));
        this.lvRight = new ListViewer(ls2);
        this.lvRight.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.lvRight.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.lvRight.setInput((Object)this.selectedList);
        Button toRight = new Button(cmp2, 8);
        toRight.setText(">");
        toRight.setLayoutData((Object)new GridData(768));
        toRight.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)SelectSchemaCatalog.this.lvLeft.getSelection();
                Iterator it = sel.iterator();
                while (it.hasNext()) {
                    IDbModel schemaOrCatalog = (IDbModel)it.next();
                    if (SelectSchemaCatalog.this.selectedList.contains(schemaOrCatalog)) continue;
                    SelectSchemaCatalog.this.selectedList.add(schemaOrCatalog);
                }
                SelectSchemaCatalog.this.lvRight.refresh();
                if (ls2.getItemCount() > 0) {
                    SelectSchemaCatalog.this.setPageComplete(true);
                } else {
                    SelectSchemaCatalog.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toRight.setToolTipText("Move selected schemas or catalogs into right list");
        Button allToRight = new Button(cmp2, 8);
        allToRight.setText(">>");
        allToRight.setLayoutData((Object)new GridData(768));
        allToRight.setToolTipText("Move all schemas or catalogs into right list");
        allToRight.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectSchemaCatalog.this.selectedList.clear();
                List ls = (List)SelectSchemaCatalog.this.lvLeft.getInput();
                SelectSchemaCatalog.this.selectedList.addAll(ls);
                SelectSchemaCatalog.this.lvRight.refresh();
                if (ls2.getItemCount() > 0) {
                    SelectSchemaCatalog.this.setPageComplete(true);
                } else {
                    SelectSchemaCatalog.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button allToLeft = new Button(cmp2, 8);
        allToLeft.setText("<<");
        allToLeft.setLayoutData((Object)new GridData(768));
        allToLeft.setToolTipText("Remove all schemas or catalogs from right list");
        allToLeft.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectSchemaCatalog.this.selectedList.clear();
                SelectSchemaCatalog.this.lvRight.refresh();
                if (ls2.getItemCount() > 0) {
                    SelectSchemaCatalog.this.setPageComplete(true);
                } else {
                    SelectSchemaCatalog.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button toLeft = new Button(cmp2, 8);
        toLeft.setText("<");
        toLeft.setLayoutData((Object)new GridData(768));
        toLeft.setToolTipText("Remove selected schemas or catalogs from right list");
        toLeft.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)SelectSchemaCatalog.this.lvRight.getSelection();
                Iterator it = sel.iterator();
                while (it.hasNext()) {
                    IDbModel schemaOrCatalog = (IDbModel)it.next();
                    SelectSchemaCatalog.this.selectedList.remove(schemaOrCatalog);
                }
                SelectSchemaCatalog.this.lvRight.refresh();
                if (ls2.getItemCount() > 0) {
                    SelectSchemaCatalog.this.setPageComplete(true);
                } else {
                    SelectSchemaCatalog.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        super.setControl((Control)composite1);
    }

    public void updateSessionNode(SessionTreeNode session) {
        this.selectedList.clear();
        this.lvRight.refresh();
        if (session.dbModel.supportsCatalogs()) {
            this.lvLeft.setInput((Object)session.dbModel.getCatalogs());
        } else if (session.dbModel.supportsSchemas()) {
            this.lvLeft.setInput((Object)session.dbModel.getSchemas());
        } else {
            this.lvLeft.setInput((Object)session.dbModel.getCatalogs());
        }
        this.lvLeft.refresh();
        this.setPageComplete(false);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        this.wizard.setSelectedSchemas(this.selectedList);
        return super.getNextPage();
    }
}

