/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.DataCache;
import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.ext.PluginManager;
import net.sourceforge.sqlexplorer.plugin.SqlHistoryChangedListener;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeModel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SQLExplorerPlugin
extends AbstractUIPlugin {
    private int count = 0;
    public static final String PLUGIN_ID = "net.sourceforge.sqlexplorer";
    public SessionTreeModel stm = new SessionTreeModel();
    public PluginManager pluginManager;
    private static SQLExplorerPlugin plugin;
    private ResourceBundle resourceBundle;
    private SQLDriverManager _driverMgr;
    private DataCache _cache;
    private AliasModel aliasModel;
    private DriverModel driverModel;
    private ListenerList listeners = new ListenerList();
    private ArrayList sqlHistory = new ArrayList();

    public static void error(String message, Throwable t) {
        SQLExplorerPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 4, String.valueOf(message), t));
    }

    public ArrayList getSQLHistory() {
        return this.sqlHistory;
    }

    public void addListener(SqlHistoryChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(SqlHistoryChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void sqlHistoryChanged() {
        Object[] ls = this.listeners.getListeners();
        int i = 0;
        while (i < ls.length) {
            try {
                ((SqlHistoryChangedListener)ls[i]).changed();
            }
            catch (Throwable throwable) {}
            ++i;
        }
    }

    public void addSQLtoHistory(String newSql) {
        boolean found = false;
        int i = 0;
        while (i < this.sqlHistory.size()) {
            String sql = (String)this.sqlHistory.get(i);
            if (sql.equals(newSql)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.sqlHistory.add(newSql);
            this.sqlHistoryChanged();
        }
    }

    public SQLDriverManager getSQLDriverManager() {
        return this._driverMgr;
    }

    public AliasModel getAliasModel() {
        return this.aliasModel;
    }

    public DriverModel getDriverModel() {
        return this.driverModel;
    }

    public SQLExplorerPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.pluginManager = new PluginManager();
            this.pluginManager.loadPlugins();
            this.pluginManager.initializePlugins();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error loading plugins preference pages", e);
        }
        this._driverMgr = new SQLDriverManager();
        this._cache = new DataCache(this._driverMgr);
        this.aliasModel = new AliasModel(this._cache);
        this.driverModel = new DriverModel(this._cache);
        Object[] aliases = this.aliasModel.getElements();
        int i = 0;
        while (i < aliases.length) {
            final ISQLAlias alias = (ISQLAlias)aliases[i];
            if (alias.isConnectAtStartup()) {
                try {
                    ISQLDriver dv = this.driverModel.getDriver(alias.getDriverIdentifier());
                    final SQLConnection conn = this._driverMgr.getConnection(dv, alias, alias.getUserName(), alias.getPassword());
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                SQLExplorerPlugin.this.stm.createSessionTreeNode(conn, alias, null, alias.getPassword());
                            }
                            catch (InterruptedException interruptedException) {
                                throw new RuntimeException();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error("Error creating sql connection to " + alias.getName(), e);
                }
            }
            ++i;
        }
        try {
            this.resourceBundle = ResourceBundle.getBundle("net.sourceforge.sqlexplorer.test");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void shutdown() throws CoreException {
        this._cache.save();
        RootSessionTreeNode rstn = this.stm.getRoot();
        rstn.closeAllConnections();
        super.shutdown();
    }

    public static SQLExplorerPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = SQLExplorerPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public int getNextElement() {
        return this.count++;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_keyword", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_multi_line_comment", (RGB)new RGB(0, 100, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_single_line_comment", (RGB)new RGB(0, 100, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_string", (RGB)new RGB(255, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_default", (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"font", (FontData[])JFaceResources.getTextFont().getFontData());
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_table", (RGB)new RGB(0, 100, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_columns", (RGB)new RGB(100, 0, 255));
        store.setDefault("preRowCount", 80);
        store.setDefault("maxSQLRows", 2000);
        store.setDefault("autocommit", true);
        store.setDefault("commitonclose", false);
        store.setDefault("assist", true);
        store.setDefault("clip_export_columns", false);
        store.setDefault("clip_export_separator", ";");
    }
}

