/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.editors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class SQLEditorInput
implements IStorageEditorInput,
IPersistableElement {
    private IStorage fStorage;
    File fFile;
    private String fName;
    private SessionTreeNode sessionNode;

    public SQLEditorInput(String name) {
        this.fName = name;
        this.createStorage();
    }

    public SQLEditorInput(File file) {
        this.fFile = file;
        this.createStorage();
    }

    private void createStorage() {
        this.fStorage = new IStorage(){

            public InputStream getContents() throws CoreException {
                try {
                    return SQLEditorInput.this.fFile != null ? new FileInputStream(SQLEditorInput.this.fFile) : this.getClearStream();
                }
                catch (IOException iOException) {
                    return this.getClearStream();
                }
            }

            private InputStream getClearStream() {
                return new ByteArrayInputStream(new byte[0]);
            }

            public IPath getFullPath() {
                return null;
            }

            public String getName() {
                return SQLEditorInput.this.getName();
            }

            public boolean isReadOnly() {
                return false;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        };
    }

    public boolean exists() {
        return this.fFile != null ? this.fFile.exists() : false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fFile != null ? this.fFile.getName() : this.fName;
    }

    public IPersistableElement getPersistable() {
        return this.fFile != null ? this : null;
    }

    public String getToolTipText() {
        return this.fFile != null ? this.fFile.getAbsolutePath() : this.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        return this.fStorage;
    }

    public File getFile() {
        return this.fFile;
    }

    public String getFactoryId() {
        return "net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInputFactory";
    }

    public void saveState(IMemento memento) {
        if (this.fFile == null) {
            return;
        }
        memento.putString("path", this.fFile.getAbsolutePath());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SQLEditorInput)) {
            return false;
        }
        SQLEditorInput input = (SQLEditorInput)obj;
        return this.fFile == null && input.fFile == null ? this.fName == input.fName || this.fName != null && this.fName.equals(input.fName) : this.fFile == input.fFile || this.fFile != null && this.fFile.equals(input.fFile);
    }

    public SessionTreeNode getSessionNode() {
        return this.sessionNode;
    }

    public void setSessionNode(SessionTreeNode node) {
        this.sessionNode = node;
    }
}

