/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.perspectives;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.plugin.views.SqlexplorerViewConstants;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class SQLExplorerPluginPerspective
implements IPerspectiveFactory {
    public void createInitialLayout(IPageLayout layout) {
        this.defineActions(layout);
        this.defineLayout(layout);
    }

    private void defineActions(IPageLayout layout) {
        List views = SqlexplorerViewConstants.getInstance().getFullViewList();
        Iterator iterator = views.iterator();
        while (iterator.hasNext()) {
            layout.addShowViewShortcut((String)iterator.next());
        }
    }

    private void defineLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(true);
        String editorArea = layout.getEditorArea();
        IFolderLayout left = layout.createFolder("topLeft", 1, 0.25f, editorArea);
        left.addView("net.sourceforge.sqlexplorer.plugin.views.DriverView");
        left.addView("net.sourceforge.sqlexplorer.plugin.views.AliasView");
        IFolderLayout main = layout.createFolder("main", 2, 0.75f, editorArea);
        main.addView("net.sourceforge.sqlexplorer.plugin.views.DBView");
        main.addView("net.sourceforge.sqlexplorer.plugin.views.ConnectionInfo");
        main.addView("net.sourceforge.sqlexplorer.plugin.views.SQLHistoryView");
        IFolderLayout bottomLeft = layout.createFolder("bottomLeft", 4, 0.5f, "topLeft");
        bottomLeft.addView(SqlexplorerViewConstants.SQLEXPLORER_CONNECTIONS);
        IFolderLayout bottom = layout.createFolder("bottom", 4, 0.5f, editorArea);
        bottom.addView("net.sourceforge.sqlexplorer.plugin.views.SqlResultsView");
    }
}

