/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.views;

import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.SqlHistoryChangedListener;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.ViewPart;

public class SQLHistoryView
extends ViewPart
implements SqlHistoryChangedListener {
    TableViewer tableViewer;

    public void createPartControl(Composite parent) {
        SQLExplorerPlugin.getDefault().addListener(this);
        this.tableViewer = new TableViewer(parent, 66304);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return SQLExplorerPlugin.getDefault().getSQLHistory().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setInput((Object)this);
        TableColumn tc = new TableColumn(table, 0);
        tc.setText("previous sql");
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 100, true));
        table.setLayout((Layout)tableLayout);
        table.layout();
        final MenuManager menuMgr = new MenuManager("#HistoryPopupMenu");
        Menu historyContextMenu = menuMgr.createContextMenu((Control)table);
        menuMgr.add((IAction)new Action(){

            public String getText() {
                return "Open in editor";
            }

            public void run() {
                try {
                    TableItem[] ti = SQLHistoryView.this.tableViewer.getTable().getSelection();
                    if (ti == null || ti.length < 1) {
                        return;
                    }
                    SQLEditorInput input = new SQLEditorInput("SQL Editor (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
                    input.setSessionNode(null);
                    IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page == null) {
                        return;
                    }
                    SQLEditor editorPart = (SQLEditor)page.openEditor((IEditorInput)input, "net.sourceforge.sqlexplorer.plugin.editors.SQLEditor");
                    editorPart.setText(ti[0].getText());
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error("Error creating sql editor", e);
                }
            }
        });
        menuMgr.add((IAction)new Action(){

            public String getText() {
                return "Remove from history";
            }

            public void run() {
                try {
                    int i = SQLHistoryView.this.tableViewer.getTable().getSelectionIndex();
                    if (i >= 0) {
                        SQLExplorerPlugin.getDefault().getSQLHistory().remove(i);
                        SQLHistoryView.this.changed();
                    }
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error("Error removing item from clipboard", e);
                }
            }
        });
        menuMgr.add((IAction)new Action(){

            public String getText() {
                return "Copy to Clipboard";
            }

            public void run() {
                try {
                    TableItem[] ti = SQLHistoryView.this.tableViewer.getTable().getSelection();
                    if (ti == null || ti.length < 1) {
                        return;
                    }
                    Clipboard cb = new Clipboard(Display.getCurrent());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    cb.setContents(new Object[]{ti[0].getText()}, new Transfer[]{textTransfer});
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error("Error copying to clipboard", e);
                }
            }
        });
        table.setMenu(historyContextMenu);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TableItem[] ti = SQLHistoryView.this.tableViewer.getTable().getSelection();
                MenuItem[] items = menuMgr.getMenu().getItems();
                if (ti == null || ti.length < 1) {
                    int i = 0;
                    while (i < items.length) {
                        items[i].setEnabled(false);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < items.length) {
                        items[i].setEnabled(true);
                        ++i;
                    }
                }
            }
        });
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    public void dispose() {
        SQLExplorerPlugin.getDefault().removeListener(this);
        super.dispose();
    }

    public void changed() {
        this.tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SQLHistoryView.this.tableViewer.refresh();
            }
        });
    }
}

