/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.preferences;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.preferences.OverlayPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public final OverlayPreferenceStore.OverlayKey[] fKeys = new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "preRowCount"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "maxSQLRows"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "autocommit"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "commitonclose"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "assist")};
    private IntegerFieldEditor fPreviewRowCountEditor;
    private IntegerFieldEditor fMaxSqlRowEditor;
    OverlayPreferenceStore fOverlayStore;
    Button fAutoCommitBox;
    Button fCommitOnCloseBox;
    Button fAssistance;

    public GeneralPreferencePage(OverlayPreferenceStore fOverlayStore) {
        this.setTitle(Messages.getString("General_Preferences_1"));
        this.fOverlayStore = fOverlayStore;
    }

    public void init(IWorkbench workbench) {
    }

    public GeneralPreferencePage() {
        this.fOverlayStore = new OverlayPreferenceStore(SQLExplorerPlugin.getDefault().getPreferenceStore(), this.fKeys);
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    protected Control createContents(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        colorComposite.setLayout((Layout)layout);
        this.fPreviewRowCountEditor = new IntegerFieldEditor("preRowCount", Messages.getString("Preview_Max_Rows_3"), colorComposite);
        this.fPreviewRowCountEditor.setValidRange(1, 100);
        this.fPreviewRowCountEditor.setErrorMessage(Messages.getString("Accepted_Range_is__1_-_100_1"));
        this.fMaxSqlRowEditor = new IntegerFieldEditor("maxSQLRows", Messages.getString("SQL_Limit_Rows_2"), colorComposite);
        this.fMaxSqlRowEditor.setValidRange(100, 5000);
        this.fMaxSqlRowEditor.setErrorMessage(Messages.getString("Accepted_Range_is__100_-_5000_3"));
        this.fAutoCommitBox = new Button(colorComposite, 32);
        this.fAutoCommitBox.setText(Messages.getString("GeneralPreferencePage.AutoCommit_1"));
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAutoCommitBox.setLayoutData((Object)gd);
        this.fCommitOnCloseBox = new Button(colorComposite, 32);
        this.fCommitOnCloseBox.setText(Messages.getString("GeneralPreferencePage.Commit_On_Close_2"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fCommitOnCloseBox.setLayoutData((Object)gd);
        this.fAssistance = new Button(colorComposite, 32);
        this.fAssistance.setText(Messages.getString("GeneralPreferencePage.Tables_and_columns_auto-completing_assistance._Use_only_with_fast_database_connections_1"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAssistance.setLayoutData((Object)gd);
        this.fAutoCommitBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralPreferencePage.this.fOverlayStore.setValue("autocommit", GeneralPreferencePage.this.fAutoCommitBox.getSelection());
                if (GeneralPreferencePage.this.fAutoCommitBox.getSelection()) {
                    GeneralPreferencePage.this.fCommitOnCloseBox.setEnabled(false);
                } else {
                    GeneralPreferencePage.this.fCommitOnCloseBox.setEnabled(true);
                }
            }
        });
        this.fCommitOnCloseBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralPreferencePage.this.fOverlayStore.setValue("commitonclose", GeneralPreferencePage.this.fCommitOnCloseBox.getSelection());
            }
        });
        this.fAssistance.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralPreferencePage.this.fOverlayStore.setValue("assist", GeneralPreferencePage.this.fAssistance.getSelection());
            }
        });
        this.initialize();
        return colorComposite;
    }

    private void initialize() {
        this.fMaxSqlRowEditor.setPreferenceStore((IPreferenceStore)this.fOverlayStore);
        this.fMaxSqlRowEditor.setPreferenceName("maxSQLRows");
        this.fMaxSqlRowEditor.setPreferencePage((PreferencePage)this);
        this.fMaxSqlRowEditor.load();
        this.fPreviewRowCountEditor.setPreferenceStore((IPreferenceStore)this.fOverlayStore);
        this.fPreviewRowCountEditor.setPreferenceName("preRowCount");
        this.fPreviewRowCountEditor.setPreferencePage((PreferencePage)this);
        this.fPreviewRowCountEditor.load();
        this.fAutoCommitBox.getDisplay().asyncExec(new Runnable(){

            public void run() {
                GeneralPreferencePage.this.fCommitOnCloseBox.setSelection(GeneralPreferencePage.this.fOverlayStore.getBoolean("commitonclose"));
                GeneralPreferencePage.this.fAutoCommitBox.setSelection(GeneralPreferencePage.this.fOverlayStore.getBoolean("autocommit"));
                if (GeneralPreferencePage.this.fAutoCommitBox.getSelection()) {
                    GeneralPreferencePage.this.fCommitOnCloseBox.setEnabled(false);
                } else {
                    GeneralPreferencePage.this.fCommitOnCloseBox.setEnabled(true);
                }
            }
        });
        this.fAssistance.getDisplay().asyncExec(new Runnable(){

            public void run() {
                GeneralPreferencePage.this.fAssistance.setSelection(GeneralPreferencePage.this.fOverlayStore.getBoolean("assist"));
            }
        });
    }

    public void dispose() {
        this.setPreferenceStore(null);
        if (this.fPreviewRowCountEditor != null) {
            this.fPreviewRowCountEditor.setPreferenceStore(null);
            this.fPreviewRowCountEditor.setPreferencePage(null);
        }
        if (this.fMaxSqlRowEditor != null) {
            this.fMaxSqlRowEditor.setPreferenceStore(null);
            this.fMaxSqlRowEditor.setPreferencePage(null);
        }
        super.dispose();
    }

    public boolean performOk() {
        if (this.fPreviewRowCountEditor != null) {
            this.fPreviewRowCountEditor.store();
        }
        if (this.fMaxSqlRowEditor != null) {
            this.fMaxSqlRowEditor.store();
        }
        this.fOverlayStore.propagate();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        if (this.fPreviewRowCountEditor != null) {
            this.fPreviewRowCountEditor.loadDefault();
        }
        if (this.fMaxSqlRowEditor != null) {
            this.fMaxSqlRowEditor.loadDefault();
        }
        super.performDefaults();
    }
}

