/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sessiontree.model;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class SessionTreeLabelProvider
extends LabelProvider {
    private HashMap imageCache = new HashMap(5);
    private ImageDescriptor rootDescriptor = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getRootIcon());
    private ImageDescriptor sessionDescriptor = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getSessionIcon());

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof RootSessionTreeNode) {
            descriptor = this.rootDescriptor;
        } else if (element instanceof SessionTreeNode) {
            descriptor = this.sessionDescriptor;
        }
        Image image = (Image)this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public String getText(Object element) {
        return element.toString();
    }

    public void dispose() {
        Iterator i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
        this.imageCache.clear();
    }
}

