/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sessiontree.model.utility;

import java.util.NoSuchElementException;

class DoublyLinkedList {
    DLLNode head;
    DLLNode last;
    int size = 0;

    DoublyLinkedList() {
    }

    public void addFirst(Object data) {
        DLLNode newNode = new DLLNode();
        newNode.data = data;
        if (this.size == 0) {
            this.last = this.head = newNode;
        } else {
            newNode.nextNode = this.head;
            this.head.previousNode = newNode;
            this.head = newNode;
        }
        ++this.size;
    }

    public void addLast(Object data) {
        DLLNode newNode = new DLLNode();
        newNode.data = data;
        if (this.size == 0) {
            this.head = newNode;
        } else {
            this.last.nextNode = newNode;
            newNode.previousNode = this.last;
        }
        this.last = newNode;
        ++this.size;
    }

    public void removeFirst() {
        if (this.size <= 1) {
            this.head = null;
            this.last = null;
        } else {
            DLLNode oldHead = this.head;
            this.head = oldHead.nextNode;
            oldHead.nextNode = null;
            this.head.previousNode = null;
        }
        --this.size;
    }

    public void removeLast() {
        if (this.size <= 1) {
            this.head = null;
            this.last = null;
        } else {
            this.last = this.last.previousNode;
            this.last.nextNode.previousNode = null;
            this.last.nextNode = null;
        }
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        DLLNode currentNode = this.last;
        while (currentNode != null) {
            DLLNode tempNode = currentNode.previousNode;
            currentNode.nextNode = null;
            currentNode.previousNode = null;
            currentNode.data = null;
            currentNode = tempNode;
        }
        this.last = null;
        this.head = null;
        this.size = 0;
    }

    public DLLIterator iterator() {
        return new DLLIterator();
    }

    protected class DLLNode {
        protected DLLNode nextNode;
        protected DLLNode previousNode;
        protected Object data;

        protected DLLNode() {
        }
    }

    public class DLLIterator {
        private DLLNode currentPreviousNode = null;
        private DLLNode currentNextNode;

        public DLLIterator() {
            this.currentNextNode = DoublyLinkedList.this.head;
        }

        public boolean hasNext() {
            if (this.currentNextNode == null) {
                return false;
            }
            return this.currentNextNode != null;
        }

        public boolean hasPrevious() {
            if (this.currentPreviousNode == null) {
                return false;
            }
            return this.currentPreviousNode != null;
        }

        public Object next() {
            if (this.currentNextNode == null) {
                throw new NoSuchElementException("Attempt to retrieve next value from DoublyLinkedList after all values have already been retrieved. Verify hasNext method returns true before calling next method.");
            }
            Object data = this.currentNextNode.data;
            DLLNode tempNode = this.currentNextNode;
            this.currentNextNode = this.currentNextNode.nextNode;
            this.currentPreviousNode = tempNode;
            return data;
        }

        public Object previous() {
            if (this.currentPreviousNode == null) {
                throw new NoSuchElementException("Attempt to retrieve previous value from head node of DoublyLinkedList. Verify hasPrevious method returns true before calling previous method.");
            }
            Object data = this.currentPreviousNode.data;
            DLLNode tempNode = this.currentPreviousNode;
            this.currentPreviousNode = this.currentPreviousNode.previousNode;
            this.currentNextNode = tempNode;
            return data;
        }

        public void resetToBeginning() {
            this.currentNextNode = DoublyLinkedList.this.head;
            this.currentPreviousNode = null;
        }

        public void resetToEnd() {
            this.currentNextNode = null;
            this.currentPreviousNode = DoublyLinkedList.this.last;
        }
    }
}

