/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqlpanel;

import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import net.sourceforge.sqlexplorer.sqleditor.SQLSourceViewerConfiguration;
import net.sourceforge.sqlexplorer.sqleditor.SQLTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SQLTextViewer
extends SourceViewer {
    IPresentationReconciler fPresentationReconciler;
    private IDocumentPartitioner partitioner;
    SQLTextTools sqlTextTools;
    IPreferenceStore store;
    IContentAssistant contentAssistant;
    public Dictionary dictionary;
    SQLSourceViewerConfiguration configuration;
    DefaultUndoManager undoManager = new DefaultUndoManager(50);
    PreferenceListener fPreferenceListener = new PreferenceListener();

    public void setDocument(IDocument dc) {
        IDocument previous = this.getDocument();
        if (previous != null) {
            this.partitioner.disconnect();
        }
        super.setDocument(dc);
        if (dc != null) {
            this.partitioner.connect(dc);
            dc.setDocumentPartitioner(this.partitioner);
            this.undoManager.connect((ITextViewer)this);
            this.setUndoManager((IUndoManager)this.undoManager);
        }
    }

    public SQLTextViewer(Composite parent, int style, IPreferenceStore store, final Dictionary dictionary, IVerticalRuler ruler) {
        super(parent, ruler, style);
        this.store = store;
        this.dictionary = dictionary;
        this.sqlTextTools = new SQLTextTools(store, dictionary);
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SQLTextViewer.this.sqlTextTools.dispose();
                SQLTextViewer.this.fPresentationReconciler.uninstall();
            }
        });
        store.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        FontData[] fData = PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)"font");
        if (fData.length > 0) {
            JFaceResources.getFontRegistry().put(fData[0].toString(), fData);
            this.getControl().setFont(JFaceResources.getFontRegistry().get(fData[0].toString()));
        }
        this.configuration = new SQLSourceViewerConfiguration(this.sqlTextTools);
        this.fPresentationReconciler = this.configuration.getPresentationReconciler(null);
        if (dictionary != null) {
            this.contentAssistant = this.configuration.getContentAssistant(null);
            if (this.contentAssistant != null) {
                this.contentAssistant.install((ITextViewer)this);
            }
        }
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install((ITextViewer)this);
        }
        this.partitioner = this.configuration.getDocumentPartitioner();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (dictionary != null) {
                    SQLTextViewer.this.contentAssistant.uninstall();
                }
            }
        });
        this.fInformationPresenter = this.configuration.getInformationPresenter((ISourceViewer)this);
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.install((ITextViewer)this);
        }
        this.setAnnotationHover(new IAnnotationHover(){

            public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
                return "hover info";
            }
        });
        this.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        String[] contentTypes = new String[]{"__dftl_partition_content_type", "sql_single_line_comment", "sql_string", "sql_multi_line_comment"};
        int i = 0;
        while (i < contentTypes.length) {
            super.setTextHover(new ITextHover(){

                public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
                    return "";
                }

                public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
                    return new Region(offset, 1);
                }
            }, contentTypes[i]);
            ++i;
        }
        super.activatePlugins();
    }

    public void setNewDictionary(Dictionary newDictionary) {
        if (this.dictionary != null && this.contentAssistant != null) {
            this.contentAssistant.uninstall();
        }
        this.dictionary = newDictionary;
        this.sqlTextTools = new SQLTextTools(this.store, this.dictionary);
        this.configuration = new SQLSourceViewerConfiguration(this.sqlTextTools);
        this.fPresentationReconciler = this.configuration.getPresentationReconciler(null);
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install((ITextViewer)this);
        }
        this.contentAssistant = this.configuration.getContentAssistant(null);
        if (this.contentAssistant != null) {
            this.contentAssistant.install((ITextViewer)this);
        }
    }

    public SQLTextViewer(Composite parent, int style, IPreferenceStore store, Dictionary dictionary) {
        this(parent, style, store, dictionary, (IVerticalRuler)new VerticalRuler(0));
    }

    void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("font")) {
            FontData[] fData = PreferenceConverter.getFontDataArray((IPreferenceStore)this.store, (String)"font");
            String des = this.store.getString("font");
            JFaceResources.getFontRegistry().put(des, fData);
            Control ctrl = this.getControl();
            if (ctrl != null) {
                ctrl.setFont(JFaceResources.getFontRegistry().get(des));
            }
        }
    }

    public void showAssistance() {
        if (this.dictionary != null) {
            this.contentAssistant.showPossibleCompletions();
        }
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel) {
        this.setDocument(document);
        if (annotationModel != null && document != null) {
            annotationModel.connect(document);
        }
    }

    public void clearText() {
        this.getTextWidget().setText("");
    }

    private class PreferenceListener
    implements IPropertyChangeListener {
        PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            SQLTextViewer.this.adaptToPreferenceChange(event);
        }
    }
}

