/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqlpanel.actions;

import java.net.URL;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.sqlpanel.SqlExecProgress;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;

public class ExecSQLAction
extends Action {
    SQLEditor txtComp;
    private ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getExecSQLIcon());
    private int maxRows;
    SessionTreeNode preferredNode;

    public ExecSQLAction(SQLEditor txtComp, int maxRows) {
        this.txtComp = txtComp;
        this.maxRows = maxRows;
    }

    public ExecSQLAction(SQLEditor txtComp, int maxRows, SessionTreeNode node_) {
        this.txtComp = txtComp;
        this.maxRows = maxRows;
        this.preferredNode = node_;
    }

    public String getText() {
        return Messages.getString("Execute_SQL_2");
    }

    public String getToolTipText() {
        return Messages.getString("Execute_SQL_3");
    }

    public void run() {
        SessionTreeNode runNode = null;
        runNode = this.preferredNode == null ? this.txtComp.getSessionTreeNode() : this.preferredNode;
        if (runNode == null) {
            return;
        }
        final SqlExecProgress sExecP = new SqlExecProgress(this.txtComp.getSQLToBeExecuted(), this.txtComp, this.maxRows, runNode);
        ProgressMonitorDialog pg = new ProgressMonitorDialog(this.txtComp.getSite().getShell());
        try {
            pg.run(true, true, (IRunnableWithProgress)sExecP);
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Error executing the SQL statement ", e);
        }
        if (sExecP.isSqlError()) {
            this.txtComp.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)ExecSQLAction.this.txtComp.getSite().getShell(), (String)Messages.getString("Error..._2"), (String)sExecP.getException().getMessage());
                }
            });
        }
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.img;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }
}

