/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqlpanel.actions;

import java.net.URL;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.SqlResultsView;
import net.sourceforge.sqlexplorer.sqlpanel.SqlRowElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class ExportToClipboard
extends Action {
    SqlResultsView compositeTableViewer;
    private ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getExportToClipBoardIcon());
    Clipboard cb;
    IPreferenceStore store;
    int ii;

    public ExportToClipboard(SqlResultsView compositeTableViewer, IPreferenceStore store, int ii) {
        this.compositeTableViewer = compositeTableViewer;
        this.setEnabled(true);
        this.cb = new Clipboard(compositeTableViewer.getSite().getShell().getDisplay());
        this.store = store;
        this.ii = ii;
    }

    public String getText() {
        return Messages.getString("ExportToClipboard.Copy_to_Clipboard_1");
    }

    public void run() {
        try {
            BusyIndicator.showWhile((Display)this.compositeTableViewer.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        String exp_sep = ExportToClipboard.this.store.getString("clip_export_separator");
                        Object[] sqlRowElements = ExportToClipboard.this.compositeTableViewer.getModel()[ExportToClipboard.this.ii].getElements();
                        int length = sqlRowElements.length;
                        boolean exp_columns = ExportToClipboard.this.store.getBoolean("clip_export_columns");
                        StringBuffer buf = new StringBuffer();
                        String separator = System.getProperty("line.separator");
                        if (exp_columns) {
                            String[] colNames = ExportToClipboard.this.compositeTableViewer.getModel()[ExportToClipboard.this.ii].getColumns();
                            int i = 0;
                            while (i < colNames.length) {
                                buf.append(colNames[i]);
                                buf.append(exp_sep);
                                ++i;
                            }
                            buf.append(separator);
                        }
                        int i = 0;
                        while (i < length) {
                            SqlRowElement row = (SqlRowElement)sqlRowElements[i];
                            int iL = row.getSize();
                            int j = 0;
                            while (j < iL) {
                                buf.append(row.getValue(j));
                                buf.append(exp_sep);
                                ++j;
                            }
                            buf.append(separator);
                            ++i;
                        }
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        ExportToClipboard.this.cb.setContents(new Object[]{buf.toString()}, new Transfer[]{textTransfer});
                    }
                    catch (Exception e) {
                        SQLExplorerPlugin.error("Error exporting to clipboard ", e);
                    }
                }
            });
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Error exporting to clipboard ", e);
        }
    }

    public String getToolTipText() {
        return Messages.getString("ExportToClipboard.Copy_To_Clipboard_4");
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.img;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }
}

