/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.sqlexplorer.dbviewer.DetailManager;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.SchemaNode;
import net.sourceforge.sqlexplorer.ext.oracle.JavaTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.utility.InfoBuilder;
import net.sourceforge.sqlexplorer.sqlpanel.SQLTextViewer;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class JavaSourceNode
implements IDbModel {
    static final Object[] keys = new Object[]{"Created", "Last DDL Time", "TimeStamp", "Status"};
    private TableViewer tv;
    IDbModel parent;
    private SQLTextViewer viewer;
    private String txt;
    private ArrayList list = new ArrayList(1);
    private SQLConnection conn;

    public Composite getComposite(DetailManager detailManager) {
        Composite comp = new Composite(detailManager.getComposite(), 0);
        comp.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder(comp, 0);
        TabItem tabItem1 = new TabItem(tabFolder, 0);
        tabItem1.setText("Source");
        tabItem1.setToolTipText("Source");
        this.viewer = new SQLTextViewer((Composite)tabFolder, 68352, detailManager.getStore(), null);
        tabItem1.setControl(this.viewer.getControl());
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText("Info");
        tabItem2.setToolTipText("Info");
        this.tv = InfoBuilder.createInfoViewer(tabFolder, tabItem2);
        this.viewer.setDocument((IDocument)new Document(this.getSource()));
        this.viewer.refresh();
        this.viewer.setEditable(false);
        final HashMap map = this.getInfo();
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                return map.entrySet().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object arg1, Object arg2) {
            }
        });
        this.tv.setInput((Object)this);
        return comp;
    }

    public Object getParent() {
        return this.parent;
    }

    public Object[] getChildren() {
        return this.list.toArray();
    }

    public String toString() {
        return this.txt;
    }

    public JavaSourceNode(IDbModel s, String name, SQLConnection conn) {
        this.conn = conn;
        this.parent = s;
        this.txt = name;
    }

    public String getOwner() {
        return ((SchemaNode)((JavaTypeNode)this.parent).getParent()).toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSource() {
        StringBuffer buf = new StringBuffer();
        String sql = "SELECT text FROM sys.all_source where owner=? and name=? and type='JAVA SOURCE' order by line";
        String delimiter = this.viewer.getTextWidget().getLineDelimiter();
        ResultSet rs = null;
        try {
            try {
                PreparedStatement ps = this.conn.prepareStatement("SELECT text FROM sys.all_source where owner=? and name=? and type='JAVA SOURCE' order by line");
                String owner = ((SchemaNode)((JavaTypeNode)this.parent).getParent()).toString();
                ps.setString(1, owner);
                ps.setString(2, this.txt);
                rs = ps.executeQuery();
                while (true) {
                    if (!rs.next()) {
                        ps.close();
                    }
                    String text = rs.getString(1);
                    if (text != null && text.length() > 0) {
                        buf.append(text.substring(0, text.length() - 1));
                    }
                    buf.append(delimiter);
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                rs.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (Throwable throwable) {
            return buf.toString();
        }
        rs.close();
        return buf.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap getInfo() {
        String sql = "SELECT  created,last_ddl_time, timestamp, status FROM sys.all_objects where owner=? and object_type='JAVA SOURCE' and object_name=?";
        HashMap<Object, String> map = new HashMap<Object, String>();
        ResultSet rs = null;
        try {
            try {
                PreparedStatement ps = this.conn.prepareStatement("SELECT  created,last_ddl_time, timestamp, status FROM sys.all_objects where owner=? and object_type='JAVA SOURCE' and object_name=?");
                String owner = this.parent.getParent().toString();
                ps.setString(1, owner);
                ps.setString(2, this.txt);
                rs = ps.executeQuery();
                if (rs.next()) {
                    map.put(keys[0], rs.getString(1));
                    map.put(keys[1], rs.getString(2));
                    map.put(keys[2], rs.getString(3));
                    map.put(keys[3], rs.getString(4));
                }
                ps.close();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                rs.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (Throwable throwable) {
            return map;
        }
        rs.close();
        return map;
    }
}

