/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle;

import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.sqlexplorer.URLUtil;
import net.sourceforge.sqlexplorer.dbviewer.model.DatabaseNode;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.SchemaNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode;
import net.sourceforge.sqlexplorer.ext.DefaultSessionPlugin;
import net.sourceforge.sqlexplorer.ext.IActivablePanel;
import net.sourceforge.sqlexplorer.ext.IEditorPlugin;
import net.sourceforge.sqlexplorer.ext.PluginException;
import net.sourceforge.sqlexplorer.ext.PluginManager;
import net.sourceforge.sqlexplorer.ext.oracle.AbstractTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.DBLinkTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.FunctionNode;
import net.sourceforge.sqlexplorer.ext.oracle.FunctionTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.InstanceNode;
import net.sourceforge.sqlexplorer.ext.oracle.JavaTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.MonitorNode;
import net.sourceforge.sqlexplorer.ext.oracle.PackageBodyNode;
import net.sourceforge.sqlexplorer.ext.oracle.PackageBodyTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.PackageNode;
import net.sourceforge.sqlexplorer.ext.oracle.PackageTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.ProcNode;
import net.sourceforge.sqlexplorer.ext.oracle.ProcTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.SchemaSessionsNode;
import net.sourceforge.sqlexplorer.ext.oracle.SecurityNode;
import net.sourceforge.sqlexplorer.ext.oracle.SequenceNode;
import net.sourceforge.sqlexplorer.ext.oracle.SequenceTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.TriggerNode;
import net.sourceforge.sqlexplorer.ext.oracle.TriggerTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.actions.CreateFunctionEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.CreatePackageBodyEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.CreatePackageEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.CreateProcedureEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.CreateTriggerEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.CreateViewEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.ExplainAction;
import net.sourceforge.sqlexplorer.ext.oracle.actions.ExtractDDL;
import net.sourceforge.sqlexplorer.ext.oracle.actions.ExtractXML;
import net.sourceforge.sqlexplorer.ext.oracle.actions.FunctionEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.PackageBodyEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.PackageEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.ProcedureEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.RefreshTypeNode;
import net.sourceforge.sqlexplorer.ext.oracle.actions.RunFunction;
import net.sourceforge.sqlexplorer.ext.oracle.actions.RunPackage;
import net.sourceforge.sqlexplorer.ext.oracle.actions.RunProcedure;
import net.sourceforge.sqlexplorer.ext.oracle.actions.TriggerEdit;
import net.sourceforge.sqlexplorer.ext.oracle.actions.ViewEdit;
import net.sourceforge.sqlexplorer.ext.oracle.panels.DependentObjectsPanel;
import net.sourceforge.sqlexplorer.ext.oracle.panels.PrivilegesPanel;
import net.sourceforge.sqlexplorer.ext.oracle.panels.StatusPanel;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;

public class OraclePlugin
extends DefaultSessionPlugin
implements IEditorPlugin {
    HashMap classMap = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public OraclePlugin() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.SequenceNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz, "plugins/icons/test.gif");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.PackageNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz2, "plugins/icons/package.gif");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.PackageBodyNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz3, "plugins/icons/package_body.gif");
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.ProcNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz4, "plugins/icons/p.gif");
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.FunctionNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz5, "plugins/icons/f.gif");
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.TriggerNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz6, "plugins/icons/test.gif");
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.SchemaSessionsNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz7, "plugins/icons/test.gif");
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.JavaSourceNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz8, "plugins/icons/test.gif");
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.DBLinkNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz9, "plugins/icons/test.gif");
    }

    public void initialize() throws PluginException {
    }

    public void load() {
    }

    public void unload() {
        super.unload();
    }

    public boolean sessionStarted(SessionTreeNode sessionNode) {
        return true;
    }

    public String getInternalName() {
        return "oraclePlugin";
    }

    public String getDescriptiveName() {
        return "Oracle Plugin for JFaceDbc";
    }

    public String getAuthor() {
        return "andreamazzolini@users.sourceforge.net";
    }

    public String getContributors() {
        return null;
    }

    public String getWebSite() {
        return "http://jfacedbc.sourceforge.net";
    }

    public String getVersion() {
        return "1.1";
    }

    private boolean isOracle(SessionTreeNode session) {
        String ORACLE = "oracle";
        String dbms = null;
        try {
            dbms = session.getSQLConnection().getSQLMetaData().getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dbms != null && dbms.toLowerCase().startsWith("oracle");
    }

    private boolean isOracle9(SessionTreeNode session) {
        String ORACLE9 = "oracle9";
        String dbms = null;
        try {
            dbms = session.getSQLConnection().getSQLMetaData().getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dbms != null && dbms.toLowerCase().startsWith("oracle9");
    }

    public IDbModel[] getSchemaAddedTypes(SchemaNode schemaNode, SessionTreeNode sessionNode) {
        if (this.isOracle(sessionNode)) {
            ArrayList<Object> ls = new ArrayList<Object>();
            SQLConnection conn = sessionNode.getConnection();
            ls.add(new SequenceTypeNode((IDbModel)schemaNode, "SEQUENCE", conn));
            ls.add(new PackageTypeNode((IDbModel)schemaNode, "PACKAGE", conn));
            ls.add(new PackageBodyTypeNode((IDbModel)schemaNode, "PACKAGE BODY", conn));
            ls.add(new FunctionTypeNode((IDbModel)schemaNode, "FUNCTION", conn));
            ls.add(new ProcTypeNode((IDbModel)schemaNode, "PROCEDURE", conn));
            ls.add(new TriggerTypeNode((IDbModel)schemaNode, "TRIGGER", conn));
            ls.add(new SchemaSessionsNode((IDbModel)schemaNode, "SESSIONS", conn));
            ls.add(new JavaTypeNode((IDbModel)schemaNode, "JAVA SOURCE", conn));
            ls.add(new DBLinkTypeNode((IDbModel)schemaNode, "DATABASE LINK", conn));
            return ls.toArray(new IDbModel[0]);
        }
        return null;
    }

    private ImageDescriptor getIcon(Class clazz) {
        URL url = null;
        String string = (String)this.classMap.get(clazz);
        URL baseURL = URLUtil.getBaseURL();
        try {
            url = new URL(baseURL, string);
            url = PluginManager.asLocalURL((URL)url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageDescriptor des = ImageDescriptor.createFromURL(url);
        return des;
    }

    public Map getIconMap() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        HashMap map = new HashMap();
        Class<?> clazz10 = class$0;
        if (clazz10 == null) {
            try {
                clazz10 = class$0 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.SequenceNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz9 = class$0) == null) {
            try {
                clazz9 = class$0 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.SequenceNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz10, this.getIcon(clazz9));
        Class<?> clazz11 = class$1;
        if (clazz11 == null) {
            try {
                clazz11 = class$1 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.PackageNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz8 = class$1) == null) {
            try {
                clazz8 = class$1 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.PackageNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz11, this.getIcon(clazz8));
        Class<?> clazz12 = class$2;
        if (clazz12 == null) {
            try {
                clazz12 = class$2 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.PackageBodyNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz7 = class$2) == null) {
            try {
                clazz7 = class$2 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.PackageBodyNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz12, this.getIcon(clazz7));
        Class<?> clazz13 = class$4;
        if (clazz13 == null) {
            try {
                clazz13 = class$4 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.FunctionNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz6 = class$4) == null) {
            try {
                clazz6 = class$4 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.FunctionNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz13, this.getIcon(clazz6));
        Class<?> clazz14 = class$3;
        if (clazz14 == null) {
            try {
                clazz14 = class$3 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.ProcNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz5 = class$3) == null) {
            try {
                clazz5 = class$3 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.ProcNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz14, this.getIcon(clazz5));
        Class<?> clazz15 = class$5;
        if (clazz15 == null) {
            try {
                clazz15 = class$5 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.TriggerNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz4 = class$5) == null) {
            try {
                clazz4 = class$5 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.TriggerNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz15, this.getIcon(clazz4));
        Class<?> clazz16 = class$6;
        if (clazz16 == null) {
            try {
                clazz16 = class$6 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.SchemaSessionsNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz3 = class$6) == null) {
            try {
                clazz3 = class$6 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.SchemaSessionsNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz16, this.getIcon(clazz3));
        Class<?> clazz17 = class$7;
        if (clazz17 == null) {
            try {
                clazz17 = class$7 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.JavaSourceNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$7) == null) {
            try {
                clazz2 = class$7 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.JavaSourceNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz17, this.getIcon(clazz2));
        Class<?> clazz18 = class$8;
        if (clazz18 == null) {
            try {
                clazz18 = class$8 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.DBLinkNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$8) == null) {
            try {
                clazz = class$8 = Class.forName("net.sourceforge.sqlexplorer.ext.oracle.DBLinkNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz18, this.getIcon(clazz));
        return map;
    }

    public IDbModel[] getDbRootAddedTypes(DatabaseNode root, SessionTreeNode sessionNode) {
        if (this.isOracle(sessionNode)) {
            ArrayList<Object> ls = new ArrayList<Object>();
            SQLConnection conn = sessionNode.getConnection();
            ls.add(new MonitorNode(root, "Monitor", conn));
            ls.add(new SecurityNode(root, "Security", conn));
            ls.add(new InstanceNode(root, "Instance", conn));
            return ls.toArray(new IDbModel[0]);
        }
        return null;
    }

    public IAction[] getTypeActionsAdded(SessionTreeNode sessionTreeNode, IDbModel node, TreeViewer tv) {
        ArrayList<Action> ls = new ArrayList<Action>();
        boolean oracle9 = this.isOracle9(sessionTreeNode);
        if (node instanceof TriggerNode) {
            ls.add(new TriggerEdit(sessionTreeNode, node));
            if (oracle9) {
                ls.add(new ExtractDDL(sessionTreeNode, node));
                ls.add(new ExtractXML(sessionTreeNode, node));
            }
        } else if (node instanceof ProcNode) {
            ls.add(new ProcedureEdit(sessionTreeNode, node));
            ls.add(new RunProcedure(sessionTreeNode, (ProcNode)node));
            if (oracle9) {
                ls.add(new ExtractDDL(sessionTreeNode, node));
                ls.add(new ExtractXML(sessionTreeNode, node));
            } else if (node instanceof SequenceNode && oracle9) {
                ls.add(new ExtractDDL(sessionTreeNode, node));
                ls.add(new ExtractXML(sessionTreeNode, node));
            }
        } else if (node instanceof FunctionNode) {
            ls.add(new FunctionEdit(sessionTreeNode, node));
            ls.add(new RunFunction(sessionTreeNode, (FunctionNode)node));
            if (oracle9) {
                ls.add(new ExtractDDL(sessionTreeNode, node));
                ls.add(new ExtractXML(sessionTreeNode, node));
            }
        } else if (node instanceof PackageNode) {
            ls.add(new PackageEdit(sessionTreeNode, node));
            ls.add(new RunPackage(sessionTreeNode, (PackageNode)node));
            if (oracle9) {
                ls.add(new ExtractDDL(sessionTreeNode, node));
                ls.add(new ExtractXML(sessionTreeNode, node));
            }
        } else if (node instanceof PackageBodyNode) {
            ls.add(new PackageBodyEdit(sessionTreeNode, node));
            ls.add(new RunPackage(sessionTreeNode, (PackageBodyNode)node));
            if (oracle9) {
                ls.add(new ExtractDDL(sessionTreeNode, node));
                ls.add(new ExtractXML(sessionTreeNode, node));
            }
        } else if (node instanceof PackageTypeNode) {
            ls.add(new RefreshTypeNode((AbstractTypeNode)node, tv));
            ls.add(new CreatePackageEdit(sessionTreeNode, node));
        } else if (node instanceof PackageBodyTypeNode) {
            ls.add(new RefreshTypeNode((AbstractTypeNode)node, tv));
            ls.add(new CreatePackageBodyEdit(sessionTreeNode, node));
        } else if (node instanceof FunctionTypeNode) {
            ls.add(new RefreshTypeNode((AbstractTypeNode)node, tv));
            ls.add(new CreateFunctionEdit(sessionTreeNode, node));
        } else if (node instanceof ProcTypeNode) {
            ls.add(new RefreshTypeNode((AbstractTypeNode)node, tv));
            ls.add(new CreateProcedureEdit(sessionTreeNode, node));
        } else if (node instanceof TriggerTypeNode) {
            ls.add(new RefreshTypeNode((AbstractTypeNode)node, tv));
            ls.add(new CreateTriggerEdit(sessionTreeNode, node));
        } else if (node instanceof SequenceTypeNode) {
            ls.add(new RefreshTypeNode((AbstractTypeNode)node, tv));
        }
        return ls.toArray(new IAction[0]);
    }

    public IAction[] getAddedActions(SessionTreeNode sessionNode, IDbModel node, TreeViewer tv) {
        ArrayList<Action> ls = new ArrayList<Action>();
        if (this.isOracle(sessionNode)) {
            TableObjectTypeNode tNode;
            boolean oracle9 = this.isOracle9(sessionNode);
            if (node instanceof TableNode) {
                TableNode tNode2 = (TableNode)node;
                if (tNode2.getParent().toString().equalsIgnoreCase("VIEW")) {
                    ls.add(new ViewEdit(sessionNode, node));
                }
                if (oracle9) {
                    ls.add(new ExtractDDL(sessionNode, (IDbModel)tNode2));
                    ls.add(new ExtractXML(sessionNode, (IDbModel)tNode2));
                }
            } else if (node instanceof TableObjectTypeNode && (tNode = (TableObjectTypeNode)node).toString().equalsIgnoreCase("VIEW")) {
                ls.add(new CreateViewEdit(sessionNode, tNode));
            }
        }
        return ls.toArray(new IAction[0]);
    }

    public IActivablePanel[] getAddedPanels(SessionTreeNode sessionNode, IDbModel node) {
        if (this.isOracle(sessionNode) && node instanceof TableNode) {
            TableNode tn = (TableNode)node;
            if (tn.isTable() || tn.isView()) {
                return new IActivablePanel[]{new PrivilegesPanel(), new DependentObjectsPanel(), new StatusPanel()};
            }
            if (tn.isSynonym()) {
                return new IActivablePanel[]{new DependentObjectsPanel()};
            }
        }
        return null;
    }

    public IContributionItem[] getContextMenuActions(SQLEditor editor) {
        SessionTreeNode session = editor.getSessionTreeNode();
        if (session == null) {
            return null;
        }
        if (this.isOracle(session)) {
            return new IContributionItem[]{new ActionContributionItem((IAction)new ExplainAction(editor))};
        }
        return null;
    }

    public IAction[] getEditorToolbarActions(SQLEditor editor) {
        return null;
    }

    public static URL getUrl(String path) {
        URL url = null;
        URL baseURL = URLUtil.getBaseURL();
        try {
            url = new URL(baseURL, path);
            url = PluginManager.asLocalURL((URL)url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDba(SQLConnection conn) {
        boolean isDba = false;
        Statement st = null;
        try {
            try {
                st = conn.createStatement();
                ResultSet rs = st.executeQuery("select GRANTED_ROLE from USER_ROLE_PRIVS");
                while (rs.next()) {
                    String role = rs.getString(1).toUpperCase();
                    if (!role.equals("DBA")) continue;
                    isDba = true;
                    break;
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                st.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        try {}
        catch (Throwable throwable) {
            return isDba;
        }
        st.close();
        return isDba;
    }
}

