/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.actions;

import java.net.URL;
import java.util.HashMap;
import java.util.Random;
import net.sourceforge.sqlexplorer.ext.oracle.OraclePlugin;
import net.sourceforge.sqlexplorer.ext.oracle.actions.explain.ExplainNode;
import net.sourceforge.sqlexplorer.ext.oracle.actions.explain.ExplainPlanDialog;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExplainAction
extends Action {
    SQLEditor editor;
    static final String createPlanTableScript = "CREATE TABLE PLAN_TABLE (  STATEMENT_ID                    VARCHAR2(30), TIMESTAMP                       DATE,  REMARKS                         VARCHAR2(80),  OPERATION                       VARCHAR2(30),  OPTIONS                         VARCHAR2(30),  OBJECT_NODE                     VARCHAR2(128),  OBJECT_OWNER                    VARCHAR2(30),  OBJECT_NAME                     VARCHAR2(30),  OBJECT_INSTANCE                 NUMBER(38),  OBJECT_TYPE                     VARCHAR2(30),  OPTIMIZER                       VARCHAR2(255),  SEARCH_COLUMNS                  NUMBER,  ID                              NUMBER(38),  PARENT_ID                       NUMBER(38),  POSITION                        NUMBER(38),  COST                            NUMBER(38),  CARDINALITY                     NUMBER(38),  BYTES                           NUMBER(38),  OTHER_TAG                       VARCHAR2(255),  PARTITION_START                 VARCHAR2(255),  PARTITION_STOP                  VARCHAR2(255),  PARTITION_ID                    NUMBER(38),  OTHER                           LONG,  DISTRIBUTION                    VARCHAR2(30))";

    public ExplainAction(SQLEditor editor) {
        this.editor = editor;
    }

    public String getText() {
        return "Show Explain Plan";
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromURL((URL)OraclePlugin.getUrl("plugins/icons/explain.gif"));
    }

    public String getToolTipText() {
        return "Show Explain Plan";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block25: {
                stn = this.editor.getSessionTreeNode();
                sqlText = this.editor.sqlTextViewer.getTextWidget().getText();
                st = stn.getConnection().createStatement();
                createPlanTable = false;
                notFoundTable = true;
                try {
                    try {
                        rs = st.executeQuery("select statement_id from plan_table");
                        notFoundTable = false;
                        rs.close();
                    }
                    catch (Throwable e) {
                        createPlanTable = MessageDialog.openQuestion(null, (String)"Plan Table not found", (String)"Plan table not found. Do you want to create a new one?");
                    }
                }
                catch (Throwable var8_11) {
                    var7_13 = null;
                    try {
                        st.close();
                        throw var8_11;
                    }
                    catch (Throwable var9_16) {
                        // empty catch block
                    }
                    throw var8_11;
                }
                {
                    var7_14 = null;
                }
                ** try [egrp 3[TRYBLOCK] [3 : 84->93)] { 
lbl27:
                // 1 sources

                st.close();
                break block25;
lbl29:
                // 1 sources

                catch (Throwable var9_17) {
                    // empty catch block
                }
            }
            if (notFoundTable && !createPlanTable) {
                return;
            }
            if (notFoundTable && createPlanTable) {
                st = stn.getConnection().createStatement();
                try {
                    st.execute("CREATE TABLE PLAN_TABLE (  STATEMENT_ID                    VARCHAR2(30), TIMESTAMP                       DATE,  REMARKS                         VARCHAR2(80),  OPERATION                       VARCHAR2(30),  OPTIONS                         VARCHAR2(30),  OBJECT_NODE                     VARCHAR2(128),  OBJECT_OWNER                    VARCHAR2(30),  OBJECT_NAME                     VARCHAR2(30),  OBJECT_INSTANCE                 NUMBER(38),  OBJECT_TYPE                     VARCHAR2(30),  OPTIMIZER                       VARCHAR2(255),  SEARCH_COLUMNS                  NUMBER,  ID                              NUMBER(38),  PARENT_ID                       NUMBER(38),  POSITION                        NUMBER(38),  COST                            NUMBER(38),  CARDINALITY                     NUMBER(38),  BYTES                           NUMBER(38),  OTHER_TAG                       VARCHAR2(255),  PARTITION_START                 VARCHAR2(255),  PARTITION_STOP                  VARCHAR2(255),  PARTITION_ID                    NUMBER(38),  OTHER                           LONG,  DISTRIBUTION                    VARCHAR2(30))");
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error((String)"Error creating the plan table", (Throwable)e);
                    MessageDialog.openError(null, (String)"Table not created", (String)"Error creating the plan table. It's impossible do create the explain plan.");
                    try {
                        st.close();
                        return;
                    }
                    catch (Throwable var7_15) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    st.close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            st = stn.getConnection().createStatement();
            id_ = Integer.toHexString(new Random().nextInt()).toUpperCase();
            st.execute("delete plan_table where statement_id='" + id_ + "'");
            st.close();
            st = stn.getConnection().createStatement();
            st.execute("EXPLAIN PLAN SET statement_id = '" + id_ + "' FOR " + sqlText);
            st.close();
            ps = stn.getConnection().prepareStatement("select object_type,operation,options,object_owner,object_name,optimizer,cardinality ,cost,id,parent_id  from  plan_table  start with id = 0 and statement_id=?  connect by prior id=parent_id and statement_id=?");
            ps.setString(1, id_);
            ps.setString(2, id_);
            rs = ps.executeQuery();
            mp = new HashMap<Integer, ExplainNode>();
            while (true) {
                if (!rs.next()) {
                    rs.close();
                    ps.close();
                    nd_parent = (ExplainNode)mp.get(new Integer(-1));
                    if (nd_parent == null) {
                        System.out.println("Null parent");
                    }
                    dlg = new ExplainPlanDialog(null, nd_parent);
                    dlg.open();
                    return;
                }
                object_type = rs.getString("object_type");
                operation = rs.getString("operation");
                options = rs.getString("options");
                object_owner = rs.getString("object_owner");
                object_name = rs.getString("object_name");
                optimizer = rs.getString("optimizer");
                cardinality = rs.getInt("cardinality");
                if (rs.wasNull()) {
                    cardinality = -1;
                }
                cost = rs.getInt("cost");
                if (rs.wasNull()) {
                    cost = -1;
                }
                parentID = rs.getInt("parent_id");
                id = rs.getInt("id");
                nd = null;
                if (id == 0) {
                    dummy = new ExplainNode(null);
                    mp.put(new Integer(-1), dummy);
                    dummy.setId(-1);
                    nd = new ExplainNode(dummy);
                    dummy.add(nd);
                    nd.setId(0);
                    mp.put(new Integer(0), nd);
                } else {
                    nd_parent = (ExplainNode)mp.get(new Integer(parentID));
                    nd = new ExplainNode(nd_parent);
                    nd_parent.add(nd);
                    mp.put(new Integer(id), nd);
                }
                nd.setCardinality(cardinality);
                nd.setCost(cost);
                nd.setObject_name(object_name);
                nd.setObject_owner(object_owner);
                nd.setObject_type(object_type);
                nd.setOperation(operation);
                nd.setOptimizer(optimizer);
                nd.setOptions(options);
            }
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error((String)"Error executing the explain plan ", (Throwable)e);
            MessageDialog.openError(null, (String)"Error", (String)"See the Eclipse error log view for more details");
        }
    }
}

