/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.actions;

import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.sourceforge.sqlexplorer.IConstants;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.SchemaNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class ExtractDDL
extends Action {
    SessionTreeNode sessionNode;
    IDbModel nd;

    public ExtractDDL(SessionTreeNode sessionNode, IDbModel nd) {
        this.sessionNode = sessionNode;
        this.nd = nd;
    }

    public String getText() {
        return "Extract DDL";
    }

    public void run() {
        String sql = "select DBMS_METADATA.GET_DDL(?,?,?) FROM dual";
        try {
            SQLConnection conn = this.sessionNode.getConnection();
            PreparedStatement stmt = conn.prepareStatement("select DBMS_METADATA.GET_DDL(?,?,?) FROM dual");
            IDbModel parent = (IDbModel)this.nd.getParent();
            String object_type = parent.toString();
            if (object_type.equalsIgnoreCase("PACKAGE BODY")) {
                object_type = "PACKAGE_BODY";
            }
            stmt.setString(1, object_type);
            stmt.setString(2, this.nd.toString());
            String owner = ((SchemaNode)parent.getParent()).toString();
            stmt.setString(3, owner);
            StringBuffer result = new StringBuffer(1000);
            ResultSet rs = stmt.executeQuery();
            String txt = null;
            if (rs.next()) {
                Clob clob = rs.getClob(1);
                txt = clob.getSubString(1L, (int)clob.length());
            }
            rs.close();
            stmt.close();
            SQLEditorInput input = new SQLEditorInput("EXTRACT DDL (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
            input.setSessionNode(this.sessionNode);
            IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                SQLEditor editorPart = (SQLEditor)page.openEditor((IEditorInput)input, IConstants.SQL_EDITOR_CLASS);
                editorPart.setText(txt);
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error((String)"Error creating sql editor for extract DDL", (Throwable)e);
            }
        }
        catch (Exception e) {
            SQLExplorerPlugin.error((String)"Error extracting ddl", (Throwable)e);
        }
    }
}

