/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.actions;

import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.ext.oracle.FunctionNode;
import net.sourceforge.sqlexplorer.ext.oracle.dialogs.ObjectEditor;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;

public class FunctionEdit
extends Action {
    IDbModel nd;
    private ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getSqlIcon());
    IPreferenceStore store;
    SessionTreeNode treeNode;

    public FunctionEdit(SessionTreeNode treeNode, IDbModel nd) {
        this.treeNode = treeNode;
        this.nd = nd;
        this.store = SQLExplorerPlugin.getDefault().getPreferenceStore();
    }

    public String getText() {
        return "Function Edit";
    }

    public void run() {
        try {
            FunctionNode fn = (FunctionNode)this.nd;
            String sql = "SELECT text,line FROM sys.all_source where owner=? and name=? and type='FUNCTION' order by line";
            SQLConnection conn = this.treeNode.getConnection();
            PreparedStatement stmt = conn.prepareStatement("SELECT text,line FROM sys.all_source where owner=? and name=? and type='FUNCTION' order by line");
            stmt.setString(1, fn.getOwner());
            stmt.setString(2, fn.toString());
            StringBuffer result1 = new StringBuffer(1000);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                result1.append(rs.getString(1));
            }
            String finalResult = "CREATE OR REPLACE ";
            String result = result1.toString();
            int start = result.toUpperCase().indexOf(fn.toString());
            int end = result.toUpperCase().indexOf(fn.toString()) + fn.toString().length();
            finalResult = String.valueOf(finalResult) + result.substring(0, start).trim() + " ";
            finalResult = String.valueOf(finalResult) + fn.getOwner() + "." + fn.toString() + result.substring(end);
            rs.close();
            stmt.close();
            ObjectEditor oe = new ObjectEditor(null, this.store, this.treeNode.getDictionary(), finalResult, "Editing " + fn.toString(), conn, "FUNCTION", fn.getOwner(), fn.toString());
            oe.open();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error((String)"Error opening function source", (Throwable)e);
        }
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.img;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }
}

