/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.actions;

import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.ext.oracle.PackageBodyNode;
import net.sourceforge.sqlexplorer.ext.oracle.dialogs.ObjectEditor;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;

public class PackageBodyEdit
extends Action {
    IDbModel nd;
    private ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getSqlIcon());
    IPreferenceStore store;
    SessionTreeNode treeNode;

    public PackageBodyEdit(SessionTreeNode treeNode, IDbModel nd) {
        this.treeNode = treeNode;
        this.nd = nd;
        this.store = SQLExplorerPlugin.getDefault().getPreferenceStore();
    }

    public String getText() {
        return "Package Body Edit";
    }

    public void run() {
        try {
            PackageBodyNode pbn = (PackageBodyNode)this.nd;
            String sql = "SELECT text,line FROM sys.all_source where owner=? and name=? and type='PACKAGE BODY' order by line";
            SQLConnection conn = this.treeNode.getConnection();
            PreparedStatement stmt = conn.prepareStatement("SELECT text,line FROM sys.all_source where owner=? and name=? and type='PACKAGE BODY' order by line");
            stmt.setString(1, pbn.getOwner());
            stmt.setString(2, pbn.toString());
            StringBuffer result1 = new StringBuffer(1000);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                result1.append(rs.getString(1));
            }
            String finalResult = "CREATE OR REPLACE ";
            String result = result1.toString();
            int start = result.toUpperCase().indexOf(pbn.toString());
            int end = result.toUpperCase().indexOf(pbn.toString()) + pbn.toString().length();
            finalResult = String.valueOf(finalResult) + result.substring(0, start).trim() + " ";
            finalResult = String.valueOf(finalResult) + pbn.getOwner() + "." + pbn.toString() + result.substring(end);
            rs.close();
            stmt.close();
            ObjectEditor oe = new ObjectEditor(null, this.store, this.treeNode.getDictionary(), finalResult, "Editing " + pbn.toString(), conn, "PACKAGE BODY", pbn.getOwner(), pbn.toString());
            oe.open();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error((String)"Error opening package body source", (Throwable)e);
        }
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.img;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }
}

