/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.actions;

import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.ext.oracle.ProcNode;
import net.sourceforge.sqlexplorer.ext.oracle.dialogs.ObjectEditor;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProcedureEdit
extends Action {
    IDbModel nd;
    private ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getSqlIcon());
    IPreferenceStore store;
    SessionTreeNode treeNode;

    public ProcedureEdit(SessionTreeNode treeNode, IDbModel nd) {
        this.treeNode = treeNode;
        this.nd = nd;
        this.store = SQLExplorerPlugin.getDefault().getPreferenceStore();
    }

    public String getText() {
        return "Procedure Edit";
    }

    public void run() {
        try {
            ProcNode pn = (ProcNode)this.nd;
            String sql = "SELECT text,line FROM sys.all_source where owner=? and name=? and type='PROCEDURE' order by line";
            SQLConnection conn = this.treeNode.getConnection();
            PreparedStatement stmt = conn.prepareStatement("SELECT text,line FROM sys.all_source where owner=? and name=? and type='PROCEDURE' order by line");
            stmt.setString(1, pn.getOwner());
            stmt.setString(2, pn.toString());
            StringBuffer result1 = new StringBuffer(1000);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                result1.append(rs.getString(1));
            }
            String finalResult = "CREATE OR REPLACE ";
            String result = result1.toString();
            int start = result.toUpperCase().indexOf(pn.toString());
            int end = result.toUpperCase().indexOf(pn.toString()) + pn.toString().length();
            finalResult = String.valueOf(finalResult) + result.substring(0, start).trim() + " ";
            finalResult = String.valueOf(finalResult) + pn.getOwner() + "." + pn.toString() + result.substring(end);
            rs.close();
            stmt.close();
            ObjectEditor oe = new ObjectEditor(null, this.store, this.treeNode.getDictionary(), finalResult, "Editing " + pn.toString(), conn, "PROCEDURE", pn.getOwner(), pn.toString());
            oe.open();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error((String)"Error opening procedure source", (Throwable)e);
        }
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.img;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }
}

