/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.actions.explain;

import net.sourceforge.sqlexplorer.ext.oracle.actions.explain.ExplainNode;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ExplainPlanDialog
extends TitleAreaDialog {
    ExplainNode nd_parent;

    public ExplainPlanDialog(Shell parentShell, ExplainNode nd_parent) {
        super(parentShell);
        this.nd_parent = nd_parent;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite pp = new Composite(parentComposite, 0);
        pp.setLayout((Layout)new FillLayout());
        pp.setLayoutData((Object)new GridData(1808));
        TableTreeViewer tv = new TableTreeViewer(pp, 67584);
        Table table = tv.getTableTree().getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn tc = new TableColumn(table, 0);
        tc.setText("");
        tc = new TableColumn(table, 0);
        tc.setText("Cost");
        tc = new TableColumn(table, 0);
        tc.setText("Cardinality");
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < 3) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50, true));
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        tv.setContentProvider((IContentProvider)new ITreeContentProvider(){
            private TableTreeViewer m_viewer;

            public Object[] getChildren(Object parentElement) {
                return ((ExplainNode)parentElement).getChildren();
            }

            public Object getParent(Object element) {
                return ((ExplainNode)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((ExplainNode)element).getChildren().length > 0;
            }

            public Object[] getElements(Object inputElement) {
                ExplainNode nd = (ExplainNode)inputElement;
                return nd.getChildren();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.m_viewer = (TableTreeViewer)viewer;
            }
        });
        tv.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider(){});
        tv.setInput((Object)this.nd_parent);
        tv.refresh();
        tv.expandAll();
        return parentComposite;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Oracle Explain Plan ");
        return contents;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Oracle Explain Plan");
        super.configureShell(newShell);
    }

    static class TreeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TreeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ExplainNode en = (ExplainNode)element;
            if (columnIndex == 0) {
                return en.toString();
            }
            if (columnIndex == 1) {
                int cost = en.getCost();
                if (cost != -1) {
                    return "" + cost;
                }
                return "";
            }
            if (columnIndex == 2) {
                int card = en.getCardinality();
                if (card != -1) {
                    return "" + card;
                }
                return "";
            }
            return "";
        }
    }
}

