/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.dialogs;

import java.util.ArrayList;
import net.sourceforge.sqlexplorer.ext.oracle.InternalFunc;
import net.sourceforge.sqlexplorer.ext.oracle.ParamObj;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class SelectFunctionPage
extends WizardPage {
    ArrayList lsFunctions;
    String name;
    String owner;
    Table tb;

    protected SelectFunctionPage(String pageName, ArrayList lsFunctions, String name, String owner) {
        super(pageName);
        this.lsFunctions = lsFunctions;
        this.setTitle(pageName);
        this.name = name;
        this.owner = owner;
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite1 = new Composite(composite, 0);
        composite1.setLayout((Layout)new FillLayout());
        this.tb = new Table(composite1, 68356);
        TableColumn tc = new TableColumn(this.tb, 0);
        tc.setText("Function or Procedure");
        int i = 0;
        while (i < this.lsFunctions.size()) {
            TableItem tItem = new TableItem(this.tb, 0);
            InternalFunc iFunc = (InternalFunc)this.lsFunctions.get(i);
            tItem.setText(SelectFunctionPage.getFuncText(iFunc.paramLs, iFunc.txt));
            ++i;
        }
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 200, true));
        this.tb.setLayout((Layout)tableLayout);
        this.tb.layout();
        this.tb.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectFunctionPage.this.tb.getSelectionCount() > 0) {
                    SelectFunctionPage.this.setPageComplete(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        super.setControl((Control)composite1);
    }

    public int getSelected() {
        return this.tb.getSelectionIndex();
    }

    public static String getFuncText(ArrayList paramLs, String txt) {
        StringBuffer msgBuf = new StringBuffer(20);
        msgBuf.append(String.valueOf(txt) + "(");
        boolean funz = false;
        if (!paramLs.isEmpty() && ((ParamObj)paramLs.get((int)0)).argumentName == null) {
            funz = true;
        }
        if (!funz) {
            int i = 0;
            int sz = paramLs.size();
            while (i < sz) {
                if (i > 0) {
                    msgBuf.append(",");
                }
                ParamObj po = (ParamObj)paramLs.get(i);
                msgBuf.append(po.argumentName);
                ++i;
            }
            msgBuf.append(")");
        } else {
            int i = 1;
            int sz = paramLs.size();
            while (i < sz) {
                if (i > 1) {
                    msgBuf.append(",");
                }
                ParamObj po = (ParamObj)paramLs.get(i);
                msgBuf.append(po.argumentName);
                ++i;
            }
            msgBuf.append(")");
        }
        return msgBuf.toString().toLowerCase();
    }
}

