/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.dialogs.actions;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class GetErrors {
    SQLConnection conn;
    String owner;
    String objectType;
    String objectName;
    static final String sql1 = " SELECT sequence, line, position, text  FROM sys.all_errors  WHERE owner =?  AND   name  =?  AND   type  =?  ORDER BY sequence";

    public GetErrors(SQLConnection conn, String owner, String objectType, String objectName) {
        this.conn = conn;
        this.owner = owner;
        this.objectName = objectName;
        this.objectType = objectType;
    }

    public String getError(StyledText st) {
        String result = "";
        try {
            PreparedStatement stmt = this.conn.prepareStatement(sql1);
            stmt.setString(1, this.owner);
            stmt.setString(2, this.objectName);
            stmt.setString(3, this.objectType);
            ResultSet rs = stmt.executeQuery();
            String sep = System.getProperty("line.separator");
            Display disp = st.getDisplay();
            final Color blue = new Color((Device)disp, 0, 0, 255);
            final Color red = new Color((Device)disp, 255, 0, 0);
            st.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    blue.dispose();
                    red.dispose();
                }
            });
            String allText = "";
            while (rs.next()) {
                String sequence = rs.getString(1);
                String line = rs.getString(2);
                String pos = rs.getString(3);
                String text = rs.getString(4);
                allText = String.valueOf(allText) + sequence + ") " + this.objectType + " " + this.owner + "." + this.objectName + " - (Line: " + line + " Column: " + pos + ")" + sep + text + sep;
            }
            st.setText(allText);
            rs.close();
            stmt.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

