/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.hbm2java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.sqlexplorer.hbm2java.ClassMapping;
import net.sourceforge.sqlexplorer.hbm2java.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

public class Generator {
    private Log log;
    private String rendererClass;
    private String baseDirName;
    private String packageName;
    private String suffix;
    private String extension;
    private boolean lowerFirstLetter;
    static /* synthetic */ Class class$0;

    public Generator() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.hbm2java.Generator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.rendererClass = "net.sourceforge.sqlexplorer.hbm2java.BasicRenderer";
        this.baseDirName = "generated";
        this.packageName = null;
        this.suffix = "";
        this.extension = "java";
        this.lowerFirstLetter = false;
    }

    public Generator(Element generateElement) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.hbm2java.Generator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.rendererClass = "net.sourceforge.sqlexplorer.hbm2java.BasicRenderer";
        this.baseDirName = "generated";
        this.packageName = null;
        this.suffix = "";
        this.extension = "java";
        this.lowerFirstLetter = false;
        String value = null;
        this.rendererClass = generateElement.getAttributeValue("renderer");
        if (this.rendererClass == null) {
            throw new Exception("attribute renderer is required.");
        }
        value = generateElement.getAttributeValue("dir");
        if (value != null) {
            this.baseDirName = value;
        }
        this.packageName = generateElement.getAttributeValue("package");
        value = generateElement.getAttributeValue("suffix");
        if (value != null) {
            this.suffix = value;
        }
        if ((value = generateElement.getAttributeValue("extension")) != null) {
            this.extension = value;
        }
        value = generateElement.getAttributeValue("lowerFirstLetter");
        this.lowerFirstLetter = Boolean.valueOf(value);
    }

    public void generate(Map classMappingsCol) throws Exception {
        Renderer renderer = (Renderer)Class.forName(this.rendererClass).newInstance();
        Iterator classMappings = classMappingsCol.values().iterator();
        while (classMappings.hasNext()) {
            ClassMapping classMapping = (ClassMapping)classMappings.next();
            this.writeRecur(classMapping, classMappingsCol, renderer);
        }
        Iterator cmpMappings = ClassMapping.getComponents();
        while (cmpMappings.hasNext()) {
            ClassMapping mapping = (ClassMapping)cmpMappings.next();
            this.write(mapping, classMappingsCol, renderer);
        }
    }

    private void writeRecur(ClassMapping classMapping, Map class2classmap, Renderer renderer) throws Exception {
        this.write(classMapping, class2classmap, renderer);
        if (!classMapping.getSubclasses().isEmpty()) {
            Iterator it = classMapping.getSubclasses().iterator();
            while (it.hasNext()) {
                this.writeRecur((ClassMapping)it.next(), class2classmap, renderer);
            }
        }
    }

    private void write(ClassMapping classMapping, Map class2classmap, Renderer renderer) throws Exception {
        File dir = this.getDir(classMapping.getGeneratedPackageName());
        File file = new File(dir, this.getFileName(classMapping.getGeneratedName()));
        this.log.debug((Object)("Writing " + file));
        PrintWriter writer = new PrintWriter(new FileOutputStream(file));
        renderer.render(this.packageName, this.getName(classMapping.getGeneratedName()), classMapping, class2classmap, writer);
        writer.close();
    }

    private String getFileName(String className) {
        return String.valueOf(this.getName(className)) + "." + this.extension;
    }

    private String getName(String className) {
        String name = null;
        name = this.lowerFirstLetter ? String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length()) : className;
        return String.valueOf(name) + this.suffix;
    }

    private File getDir(String packageName) throws Exception {
        File baseDir = new File(this.baseDirName);
        File dir = null;
        dir = this.packageName == null ? new File(baseDir, packageName == null ? "" : packageName.replace('.', File.separatorChar)) : new File(baseDir, this.packageName.replace('.', File.separatorChar));
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new Exception("The path: " + dir.getCanonicalPath() + " exists, but is not a directory");
            }
        } else if (!dir.mkdirs()) {
            throw new Exception("unable to create directory: " + dir.getCanonicalPath());
        }
        return dir;
    }

    public String getBaseDirName() {
        return this.baseDirName;
    }

    public void setBaseDirName(String baseDirName) {
        if (baseDirName != null) {
            this.baseDirName = baseDirName;
        }
    }
}

