/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.mssql;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.sqlexplorer.URLUtil;
import net.sourceforge.sqlexplorer.dbviewer.model.CatalogNode;
import net.sourceforge.sqlexplorer.dbviewer.model.DatabaseNode;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode;
import net.sourceforge.sqlexplorer.ext.DefaultSessionPlugin;
import net.sourceforge.sqlexplorer.ext.PluginManager;
import net.sourceforge.sqlexplorer.ext.mssql.CatalogSessionsNode;
import net.sourceforge.sqlexplorer.ext.mssql.MonitorNode;
import net.sourceforge.sqlexplorer.ext.mssql.ProcNode;
import net.sourceforge.sqlexplorer.ext.mssql.ProcTypeNode;
import net.sourceforge.sqlexplorer.ext.mssql.TriggerNode;
import net.sourceforge.sqlexplorer.ext.mssql.TriggerTypeNode;
import net.sourceforge.sqlexplorer.ext.mssql.UDFNode;
import net.sourceforge.sqlexplorer.ext.mssql.UDFTypeNode;
import net.sourceforge.sqlexplorer.ext.mssql.actions.CreateFunctionEdit;
import net.sourceforge.sqlexplorer.ext.mssql.actions.CreateProcedureEdit;
import net.sourceforge.sqlexplorer.ext.mssql.actions.CreateTriggerEdit;
import net.sourceforge.sqlexplorer.ext.mssql.actions.CreateViewEdit;
import net.sourceforge.sqlexplorer.ext.mssql.actions.FunctionEdit;
import net.sourceforge.sqlexplorer.ext.mssql.actions.ProcedureEdit;
import net.sourceforge.sqlexplorer.ext.mssql.actions.TriggerEdit;
import net.sourceforge.sqlexplorer.ext.mssql.actions.ViewEdit;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;

public class MssqlPlugin
extends DefaultSessionPlugin {
    private static final ILogger s_log;
    HashMap classMap = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.ext.mssql.MssqlPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_log = LoggerController.createLogger((Class)clazz);
    }

    public MssqlPlugin() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("net.sourceforge.sqlexplorer.ext.mssql.ProcNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz, "plugins/icons/test.gif");
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("net.sourceforge.sqlexplorer.ext.mssql.UDFNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz2, "plugins/icons/f.gif");
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("net.sourceforge.sqlexplorer.ext.mssql.CatalogSessionsNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz3, "plugins/icons/test.gif");
    }

    public void load() {
    }

    public String getInternalName() {
        return "mssql Plugin";
    }

    public String getDescriptiveName() {
        return "Microsoft SQL Server Plugin for JFaceDbc";
    }

    public String getAuthor() {
        return "andreamazzolini@users.sourceforge.net";
    }

    public String getWebSite() {
        return "http://jfacedbc.sourceforge.net";
    }

    public String getVersion() {
        return "0.1";
    }

    private boolean isMssql(SessionTreeNode session) {
        String MICROSOFT = "microsoft";
        String dbms = null;
        try {
            dbms = session.getSQLConnection().getSQLMetaData().getDatabaseProductName();
        }
        catch (SQLException ex) {
            s_log.debug((Object)"Error in getDatabaseProductName()", (Throwable)ex);
        }
        return dbms != null && dbms.toLowerCase().startsWith("microsoft");
    }

    public IDbModel[] getCatalogAddedTypes(CatalogNode catalogNode, SessionTreeNode sessionNode) {
        if (this.isMssql(sessionNode)) {
            ArrayList<Object> ls = new ArrayList<Object>();
            SQLConnection conn = sessionNode.getConnection();
            ls.add(new ProcTypeNode((IDbModel)catalogNode, "PROCEDURE", conn));
            ls.add(new TriggerTypeNode((IDbModel)catalogNode, "TRIGGER", conn));
            ls.add(new UDFTypeNode((IDbModel)catalogNode, "FUNCTIONS", conn));
            ls.add(new CatalogSessionsNode((IDbModel)catalogNode, "SESSIONS", conn));
            return ls.toArray(new IDbModel[0]);
        }
        return null;
    }

    private ImageDescriptor getIcon(Class clazz) {
        URL url = null;
        String string = (String)this.classMap.get(clazz);
        URL baseURL = URLUtil.getBaseURL();
        try {
            url = new URL(baseURL, string);
            url = PluginManager.asLocalURL((URL)url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageDescriptor des = ImageDescriptor.createFromURL(url);
        return des;
    }

    public Map getIconMap() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        HashMap map = new HashMap();
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("net.sourceforge.sqlexplorer.ext.mssql.ProcNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz3 = class$1) == null) {
            try {
                clazz3 = class$1 = Class.forName("net.sourceforge.sqlexplorer.ext.mssql.ProcNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz4, this.getIcon(clazz3));
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("net.sourceforge.sqlexplorer.ext.mssql.UDFNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$2) == null) {
            try {
                clazz2 = class$2 = Class.forName("net.sourceforge.sqlexplorer.ext.mssql.UDFNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz5, this.getIcon(clazz2));
        Class<?> clazz6 = class$3;
        if (clazz6 == null) {
            try {
                clazz6 = class$3 = Class.forName("net.sourceforge.sqlexplorer.ext.mssql.CatalogSessionsNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$3) == null) {
            try {
                clazz = class$3 = Class.forName("net.sourceforge.sqlexplorer.ext.mssql.CatalogSessionsNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz6, this.getIcon(clazz));
        return map;
    }

    public IAction[] getTypeActionsAdded(SessionTreeNode sessionTreeNode, IDbModel node, TreeViewer tv) {
        ArrayList<Action> ls = new ArrayList<Action>();
        if (node instanceof ProcNode) {
            ls.add(new ProcedureEdit(sessionTreeNode, node));
        } else if (node instanceof ProcTypeNode) {
            ls.add(new CreateProcedureEdit(sessionTreeNode, node));
        } else if (node instanceof TriggerNode) {
            ls.add(new TriggerEdit(sessionTreeNode, node));
        } else if (node instanceof TriggerTypeNode) {
            ls.add(new CreateTriggerEdit(sessionTreeNode, node));
        } else if (node instanceof UDFNode) {
            ls.add(new FunctionEdit(sessionTreeNode, node));
        } else if (node instanceof UDFTypeNode) {
            ls.add(new CreateFunctionEdit(sessionTreeNode, node));
        }
        return ls.toArray(new IAction[0]);
    }

    public IAction[] getAddedActions(SessionTreeNode sessionNode, IDbModel node, TreeViewer tv) {
        ArrayList<Action> ls = new ArrayList<Action>();
        if (this.isMssql(sessionNode)) {
            TableObjectTypeNode tNode;
            if (node instanceof TableNode) {
                TableNode tNode2 = (TableNode)node;
                if (tNode2.getParent().toString().equalsIgnoreCase("VIEW")) {
                    ls.add(new ViewEdit(sessionNode, node));
                }
            } else if (node instanceof TableObjectTypeNode && (tNode = (TableObjectTypeNode)node).toString().equalsIgnoreCase("VIEW")) {
                ls.add(new CreateViewEdit(sessionNode, tNode));
            }
        }
        return ls.toArray(new IAction[0]);
    }

    public IDbModel[] getDbRootAddedTypes(DatabaseNode root, SessionTreeNode sessionNode) {
        if (this.isMssql(sessionNode)) {
            ArrayList<MonitorNode> ls = new ArrayList<MonitorNode>();
            SQLConnection conn = sessionNode.getConnection();
            ls.add(new MonitorNode(root, "Monitor", conn));
            return ls.toArray(new IDbModel[0]);
        }
        return null;
    }
}

