/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.shelled.ui.editors;

import com.something.eclipse.shelled.ui.text.SHWordFinder;
import com.something.eclipse.shelled.ui.text.hover.SHTextHover;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class SHInformationProvider
implements IInformationProvider {
    protected IEditorPart fEditor;
    protected IPartListener fPartListener;
    protected String fCurrentPerspective;
    protected SHTextHover fImplementation;

    public SHInformationProvider(IEditorPart editor) {
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fPartListener = new EditorWatcher();
            IWorkbenchWindow window = this.fEditor.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener(this.fPartListener);
            this.update();
        }
    }

    protected void update() {
        IPerspectiveDescriptor perspective;
        IWorkbenchWindow window = this.fEditor.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (perspective = page.getPerspective()) != null) {
            String perspectiveId = perspective.getId();
            if (this.fCurrentPerspective == null || this.fCurrentPerspective != perspectiveId) {
                this.fCurrentPerspective = perspectiveId;
                this.fImplementation = new SHTextHover();
            }
        }
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            return SHWordFinder.findWord(textViewer.getDocument(), offset);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        String s;
        if (this.fImplementation != null && (s = this.fImplementation.getHoverInfo(textViewer, subject)) != null && s.trim().length() > 0) {
            return s;
        }
        return null;
    }

    class EditorWatcher
    implements IPartListener {
        EditorWatcher() {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == SHInformationProvider.this.fEditor) {
                SHInformationProvider.this.fEditor.getSite().getWorkbenchWindow().getPartService().removePartListener(SHInformationProvider.this.fPartListener);
                SHInformationProvider.this.fPartListener = null;
            }
        }

        public void partActivated(IWorkbenchPart part) {
            SHInformationProvider.this.update();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            SHInformationProvider.this.update();
        }
    }
}

