/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.shelled.ui.text;

import com.something.eclipse.script.text.ScriptScanner;
import com.something.eclipse.script.text.WhitespaceDetector;
import com.something.eclipse.shelled.ui.editors.ColorConstants;
import com.something.eclipse.shelled.ui.editors.ColorManager;
import com.something.eclipse.shelled.ui.text.SHDollarRule;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class SHDoubleQuoteScanner
extends ScriptScanner {
    private int shellType;
    private ColorManager manager;

    public SHDoubleQuoteScanner(ColorManager manager, int shellType) {
        this.shellType = shellType;
        this.manager = manager;
    }

    protected IRule[] createRules() {
        ArrayList<Object> rules = new ArrayList<Object>(50);
        new Token((Object)new TextAttribute(this.manager.getColor(ColorConstants.FUNCTION)));
        new Token((Object)new TextAttribute(this.manager.getColor(ColorConstants.DEFAULT)));
        Token evalToken = new Token((Object)new TextAttribute(this.manager.getColor(ColorConstants.EVAL_TYPE)));
        Token singleQuoteToken = new Token((Object)new TextAttribute(this.manager.getColor(ColorConstants.SINGLE_QUOTE)));
        Token varToken = new Token((Object)new TextAttribute(this.manager.getColor(ColorConstants.VARIABLE_TYPE)));
        IWordDetector dollarDetector = new IWordDetector(){

            public boolean isWordStart(char c) {
                return c == '$';
            }

            public boolean isWordPart(char c) {
                return Character.isLetterOrDigit(c);
            }
        };
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(new SHDollarRule(dollarDetector, Token.UNDEFINED, (IToken)varToken, false, '{', '}'));
        rules.add(new SingleLineRule("$(", ")", (IToken)evalToken, '\\', false));
        rules.add(new SingleLineRule("`", "`", (IToken)evalToken, '\\', false));
        rules.add(new SingleLineRule("'", "'", (IToken)singleQuoteToken, '\\', false));
        IRule[] rule = new IRule[rules.size()];
        return rules.toArray(rule);
    }
}

