/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.script.strategies;

import java.text.CharacterIterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.rules.IWordDetector;

public class DoubleClickStrategy
implements ITextDoubleClickStrategy {
    private IWordDetector wordDetector;
    private DocumentCharacterIterator fDocIter = new DocumentCharacterIterator();

    public DoubleClickStrategy(IWordDetector wordDetector) {
        this.wordDetector = wordDetector;
    }

    public void doubleClicked(ITextViewer viewer) {
        int position = viewer.getSelectedRange().x;
        if (position < 0) {
            return;
        }
        IDocument document = viewer.getDocument();
        try {
            IRegion line = document.getLineInformationOfOffset(position);
            if (position == line.getOffset() + line.getLength()) {
                return;
            }
            this.fDocIter.setDocument(document, line);
            char c = this.fDocIter.setIndex(position);
            while (c != '\uffff' && this.wordDetector.isWordPart(c)) {
                c = this.fDocIter.next();
            }
            int end = this.fDocIter.getIndex();
            char c2 = this.fDocIter.setIndex(position);
            while (c2 != '\uffff' && this.wordDetector.isWordPart(c2)) {
                c2 = this.fDocIter.previous();
            }
            int start = this.fDocIter.getIndex() + 1;
            if (start < end) {
                viewer.setSelectedRange(start, end - start);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private static class DocumentCharacterIterator
    implements CharacterIterator {
        private IDocument fDocument;
        private int fOffset = -1;
        private int fEndOffset = -1;
        private int fIndex = -1;

        DocumentCharacterIterator() {
        }

        public void setDocument(IDocument document, IRegion iteratorRange) {
            this.fDocument = document;
            this.fOffset = iteratorRange.getOffset();
            this.fEndOffset = this.fOffset + iteratorRange.getLength() + 1;
            --this.fOffset;
        }

        public char first() {
            this.fIndex = this.fOffset;
            return this.current();
        }

        public char last() {
            this.fIndex = this.fOffset < this.fEndOffset ? this.fEndOffset - 1 : this.fEndOffset;
            return this.current();
        }

        public char current() {
            if (this.fOffset <= this.fIndex && this.fIndex < this.fEndOffset) {
                try {
                    return this.fDocument.getChar(this.fIndex);
                }
                catch (BadLocationException badLocationException) {}
            }
            return '\uffff';
        }

        public char next() {
            if (this.fIndex == this.fEndOffset - 1) {
                return '\uffff';
            }
            if (this.fIndex < this.fEndOffset) {
                ++this.fIndex;
            }
            return this.current();
        }

        public char previous() {
            if (this.fIndex == this.fOffset) {
                return '\uffff';
            }
            if (this.fIndex > this.fOffset) {
                --this.fIndex;
            }
            return this.current();
        }

        public char setIndex(int index) {
            this.fIndex = index;
            return this.current();
        }

        public int getBeginIndex() {
            return this.fOffset;
        }

        public int getEndIndex() {
            return this.fEndOffset;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public Object clone() {
            DocumentCharacterIterator i = new DocumentCharacterIterator();
            i.fDocument = this.fDocument;
            i.fIndex = this.fIndex;
            i.fOffset = this.fOffset;
            i.fEndOffset = this.fEndOffset;
            return i;
        }
    }
}

