/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.script.text;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.PatternRule;

public class ContinuedEndOfLineRule
extends PatternRule {
    private IToken successToken;
    private char startChar;
    private char newLineEscapeCharacter;

    public ContinuedEndOfLineRule(String startSequence, String endSequence, IToken successToken, char newLineEscapeCharacter) {
        this(startSequence, endSequence, successToken, newLineEscapeCharacter, '\u0000');
    }

    public ContinuedEndOfLineRule(String startSequence, String endSequence, IToken successToken, char newLineEscapeCharacter, char escapeCharacter) {
        super(startSequence, endSequence, successToken, escapeCharacter, true, false);
        this.newLineEscapeCharacter = newLineEscapeCharacter;
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = scanner.read()) != -1) {
            boolean newLine = false;
            if (c == this.newLineEscapeCharacter) {
                int eolChar = scanner.read();
                int i = 0;
                while (i < delimiters.length) {
                    if (eolChar == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], true)) {
                        int j = 0;
                        while (j < delimiters[i].length) {
                            scanner.read();
                            ++j;
                        }
                        newLine = true;
                        break;
                    }
                    ++i;
                }
                if (!newLine) {
                    scanner.unread();
                }
            }
            if (newLine) continue;
            if (c == this.fEscapeCharacter) {
                scanner.read();
                continue;
            }
            if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (!this.sequenceDetected(scanner, this.fEndSequence, true)) continue;
                return true;
            }
            if (!this.fBreaksOnEOL) continue;
            int i = 0;
            while (i < delimiters.length) {
                if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], true)) {
                    return false;
                }
                ++i;
            }
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        scanner.unread();
        return false;
    }

    private static char[] wordStarts(String[] words) {
        HashSet<Character> set = new HashSet<Character>();
        int i = 0;
        while (i < words.length) {
            set.add(new Character(words[i].toCharArray()[0]));
            ++i;
        }
        char[] letterChars = new char[set.size()];
        int i2 = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Character character = (Character)iter.next();
            letterChars[i2] = character.charValue();
            ++i2;
        }
        Arrays.sort(letterChars);
        return letterChars;
    }
}

