/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.script.text;

import com.something.eclipse.script.text.DocumentAndCommandScanner;
import com.something.eclipse.script.text.IndentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;

public class ScriptAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    private DocumentAndCommandScanner scanner = new DocumentAndCommandScanner();

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && this.endsWithDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if (c.text.length() > 0) {
            try {
                IToken token;
                int docLength = d.getLength();
                int p = c.offset == docLength ? c.offset - 1 : c.offset;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                this.scanner.setRange(d, c, lineOffset, c.offset - lineOffset);
                while (!(token = this.scanner.nextToken()).isEOF()) {
                    IndentType type;
                    if (!token.isOther() || ((type = (IndentType)token.getData()) == null || type != IndentType.DECREMENT) && type != IndentType.INFLEXION) continue;
                    this.smartInsertAfterBracket(d, c);
                    break;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private boolean endsWithDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (txt.endsWith(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int findMatchingOpenBracket(IDocument document, int line, int end, int closingBracketIncrease) throws BadLocationException {
        int start = document.getLineOffset(line);
        int brackcount = this.getBracketCount(document, start, end, false) - closingBracketIncrease;
        while (brackcount < 0) {
            if (--line < 0) {
                return -1;
            }
            start = document.getLineOffset(line);
            end = start + document.getLineLength(line) - 1;
            brackcount += this.getBracketCount(document, start, end, false);
        }
        return line;
    }

    private int getBracketCount(IDocument document, int start, int end, boolean ignoreCloseBrackets) throws BadLocationException {
        IToken token;
        int bracketcount = 0;
        this.scanner.setRange(document, start, end - start);
        while (!(token = this.scanner.nextToken()).isEOF()) {
            if (!token.isOther()) continue;
            IndentType type = (IndentType)token.getData();
            if (type == IndentType.INCREMENT || ignoreCloseBrackets && type == IndentType.INFLEXION) {
                ++bracketcount;
                continue;
            }
            if (type != IndentType.DECREMENT) continue;
            --bracketcount;
        }
        return bracketcount;
    }

    private int getCommentEnd(IDocument document, int position, int end) throws BadLocationException {
        int currentPosition = position;
        while (currentPosition < end) {
            char curr = document.getChar(currentPosition);
            if (curr != '*' || ++currentPosition >= end || document.getChar(currentPosition) != '/') continue;
            return currentPosition + 1;
        }
        return end;
    }

    protected String getIndentOfLine(IDocument document, int line) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line) - 1;
            int whiteend = this.findEndOfWhiteSpace(document, start, end);
            return document.get(start, whiteend - start);
        }
        return "";
    }

    private int getStringEnd(IDocument document, int position, int end, char character) throws BadLocationException {
        int currentPosition = position;
        while (currentPosition < end) {
            char currentCharacter = document.getChar(currentPosition);
            ++currentPosition;
            if (currentCharacter == '\\') {
                ++currentPosition;
                continue;
            }
            if (currentCharacter != character) continue;
            return currentPosition;
        }
        return end;
    }

    protected void smartIndentAfterNewLine(IDocument document, DocumentCommand command) {
        int docLength = document.getLength();
        if (command.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int p = command.offset == docLength ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(command.text);
            if (command.offset < docLength && document.getChar(command.offset) == '}') {
                int indLine = this.findMatchingOpenBracket(document, line, command.offset, 0);
                if (indLine == -1) {
                    indLine = line;
                }
                buf.append(this.getIndentOfLine(document, indLine));
            } else {
                int start = document.getLineOffset(line);
                int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
                buf.append(document.get(start, whiteend - start));
                if (this.getBracketCount(document, start, command.offset, true) > 0) {
                    buf.append("\t");
                }
            }
            command.text = buf.toString();
        }
        catch (BadLocationException x) {
            x.printStackTrace(System.err);
        }
    }

    protected void smartInsertAfterBracket(IDocument document, DocumentCommand command) {
        if (command.offset == -1 || document.getLength() == 0) {
            return;
        }
        try {
            int whiteend;
            int p = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            int start = document.getLineOffset(line);
            int i = whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
            while (i < command.offset) {
                if (Character.isWhitespace(document.getChar(i))) {
                    return;
                }
                ++i;
            }
            int indLine = this.findMatchingOpenBracket(document, line, command.offset, 1);
            StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(document, indLine));
            replaceText.append(document.get(whiteend, command.offset - whiteend));
            replaceText.append(command.text);
            command.length = command.offset - start;
            command.offset = start;
            command.text = replaceText.toString();
        }
        catch (BadLocationException x) {
            x.printStackTrace(System.err);
        }
    }

    public void setRules(IRule[] rules) {
        this.scanner.setRules(rules);
    }
}

