/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class FileUtil {
    public static String readTextFile(File f) throws IOException {
        String inputLine;
        StringBuffer buf = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        while ((inputLine = in.readLine()) != null) {
            buf.append(inputLine);
            buf.append('\n');
        }
        in.close();
        return buf.toString();
    }

    public static void toTextFile(File f, String content) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        out.write(content.getBytes("UTF-8"));
        out.close();
    }

    public static void copy(String inputFilename, String outputFilename) throws IOException {
        FileUtil.copy(new File(inputFilename), new File(outputFilename));
    }

    public static void copy(File input, File output) throws IOException {
        if (input.isDirectory() && output.isDirectory()) {
            FileUtil.copyDir(input, output);
        } else {
            FileUtil.copyFile(input, output);
        }
    }

    public static void copyFile(File inputFile, File outputFile) throws IOException {
        int n;
        BufferedInputStream fr = new BufferedInputStream(new FileInputStream(inputFile));
        BufferedOutputStream fw = new BufferedOutputStream(new FileOutputStream(outputFile));
        byte[] buf = new byte[8192];
        while ((n = fr.read(buf)) >= 0) {
            fw.write(buf, 0, n);
        }
        fr.close();
        fw.close();
    }

    public static void copyDir(File inputDir, File outputDir) throws IOException {
        File[] files = inputDir.listFiles();
        int i = 0;
        while (i < files.length) {
            File destFile = new File(String.valueOf(outputDir.getAbsolutePath()) + File.separator + files[i].getName());
            if (!destFile.exists() && files[i].isDirectory()) {
                destFile.mkdir();
            }
            FileUtil.copy(files[i], destFile);
            ++i;
        }
    }

    public static boolean dirContainsFiles(File dir, String extension, boolean recursive) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() && files[i].getName().endsWith(extension)) {
                return true;
            }
            if (recursive && files[i].isDirectory()) {
                return FileUtil.dirContainsFiles(files[i], extension, recursive);
            }
            ++i;
        }
        return false;
    }

    public static String readPropertyInXMLFile(File file, String property) throws IOException {
        String content = FileUtil.readTextFile(file);
        int startTagIdx = content.indexOf("<" + property + ">");
        int endTagIdx = content.indexOf("</" + property + ">");
        if (startTagIdx == -1) {
            throw new IOException("Property " + property + " not found in file " + file);
        }
        return content.substring(startTagIdx + property.length() + 2, endTagIdx);
    }

    public static void removeDir(File dir) throws IOException {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                FileUtil.removeDir(files[i]);
            } else {
                files[i].delete();
            }
            ++i;
        }
        dir.delete();
    }
}

